<?php

/**
 * @package     JohnCMS
 * @link        http://johncms.com
 * @copyright   Copyright (C) 2008-2011 JohnCMS Community
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      http://johncms.com/about
 */

define('_IN_JOHNCMS', 1);

$rootpath = '';
require('incfiles/core.php');
$textl = $lng['registration'];
$headmod = 'registration';
require('incfiles/head.php');
$lng_reg = core::load_lng('registration');

// Если регистрация закрыта, выводим предупреждение
if (core::$deny_registration || !$set['mod_reg']) {
    echo '<p>' . $lng_reg['registration_closed'] . '</p>';
    require('incfiles/end.php');
    exit;
}

$captcha = isset($_POST['captcha']) ? trim($_POST['captcha']) : NULL;
$reg_nick = isset($_POST['nick']) ? trim($_POST['nick']) : '';
$lat_nick = functions::rus_lat(mb_strtolower($reg_nick));
$reg_pass = isset($_POST['password']) ? trim($_POST['password']) : '';
$reg_name = isset($_POST['imname']) ? trim($_POST['imname']) : '';
$reg_mail = isset($_POST['mail']) ? trim($_POST['mail']) : '';
$reg_dayb = isset($_POST['dayb']) ? trim($_POST['dayb']) : '';
$reg_monthb = isset($_POST['monthb']) ? trim($_POST['monthb']) : '';
$reg_yearofbirth = isset($_POST['yearofbirth']) ? trim($_POST['yearofbirth']) : '';
$reg_live = isset($_POST['live']) ? trim($_POST['live']) : '';
$reg_about = isset($_POST['about']) ? trim($_POST['about']) : '';
$reg_mibile = isset($_POST['mibile']) ? trim($_POST['mibile']) : '';
$reg_icq = isset($_POST['icq']) ? trim($_POST['icq']) : '';
$reg_skype = isset($_POST['skype']) ? trim($_POST['skype']) : '';
$reg_jabber = isset($_POST['jabber']) ? trim($_POST['jabber']) : '';
$reg_www = isset($_POST['www']) ? trim($_POST['www']) : '';
$reg_sex = isset($_POST['sex']) ? functions::check(mb_substr(trim($_POST['sex']), 0, 2)) : '';

echo '<div class="phdr"><b>' . $lng['registration'] . '</b></div>';
if (isset($_POST['submit'])) {
    // Принимаем переменные
    $error = array();
    // Проверка Логина
    if (empty($reg_nick))
        $error['login'][] = $lng_reg['error_nick_empty'];
    elseif (mb_strlen($reg_nick) < 2 || mb_strlen($reg_nick) > 15)
        $error['login'][] = $lng_reg['error_wrong_lenght'];
    if (preg_match('/[^\da-z\-\@\*\(\)\?\!\~\_\=\[\]]+/', $lat_nick))
        $error['login'][] = $lng['error_wrong_symbols'];
	// Проверка имени
    if (empty($reg_name))
        $error['imname'][] = $lng_reg['error_name_empty'];
    elseif (mb_strlen($reg_name) < 2 || mb_strlen($reg_name) > 30)
        $error['imname'][] = $lng_reg['error_wrong_lenght'];
    // Проверка пароля
    if (empty($reg_pass)) $error['password'][] = $lng['error_empty_password'];
    elseif (mb_strlen($reg_pass) < 5 || mb_strlen($reg_pass) > 15) $error['password'][] = $lng['error_wrong_lenght'];
    if (preg_match('/[^\dA-Za-z]+/', $reg_pass)) $error['password'][] = $lng['error_wrong_symbols'];
	// Проверка почты
    if (empty($reg_mail))
        $error['mail'][] = $lng_reg['error_mail_empty'];
    elseif (mb_strlen($reg_mail) < 6 || mb_strlen($reg_mail) > 40)
        $error['mail'][] = $lng_reg['error_wrong_lenght'];
	// Проверка анкетных данных
    if (empty($reg_about))
        $error['about'][] = $lng_reg['error_about_empty'];
    elseif (mb_strlen($reg_about) < 10 || mb_strlen($reg_about) > 500)
        $error['about'][] = $lng_reg['error_wrong_lenght'];
	// Проверка даты рождения
    if (empty($reg_dayb))
        $error['dayb'][] = $lng_reg['dayb'];
	if (empty($reg_monthb))
        $error['monthb'][] = $lng_reg['monthb'];
	if (empty($reg_yearofbirth))
        $error['yearofbirth'][] = $lng_reg['yearofbirth'];
	// Проверка города
    if (empty($reg_live))
        $error['live'][] = $lng_reg['error_live_empty'];
    elseif (mb_strlen($reg_name) < 2 || mb_strlen($reg_name) > 30)
        $error['live'][] = $lng_reg['error_wrong_lenght'];
    // Проверка пола
    if ($reg_sex != 'm' && $reg_sex != 'zh') $error['sex'] = $lng_reg['error_sex'];
    // Проверка кода CAPTCHA
    if (!$captcha || !isset($_SESSION['code']) || mb_strlen($captcha) < 4 || $captcha != $_SESSION['code']) $error['captcha'] = $lng['error_wrong_captcha'];
    unset($_SESSION['code']);
    // Проверка переменных
    if (empty($error)) {
        $pass = md5(md5($reg_pass));
        $reg_name = functions::check(mb_substr($reg_name, 0, 20));
        $reg_about = functions::check(mb_substr($reg_about, 0, 500));
        // Проверка, занят ли ник
        $req = mysql_query("SELECT * FROM `users` WHERE `name_lat`='" . mysql_real_escape_string($lat_nick) . "'");
        if (mysql_num_rows($req) != 0) {
            $error['login'][] = $lng_reg['error_nick_occupied'];
        }
		// Проверка, занят ли email
        $ren = mysql_query("SELECT * FROM `users` WHERE `mail`='" . mysql_real_escape_string($reg_mail) . "'");
        if (mysql_num_rows($ren) != 0) {
            $error['mail'][] = $lng_reg['error_mail_occupied'];
        }
    }
    if (empty($error)) {
        $preg = $set['mod_reg'] > 1 ? 1 : 0;
        mysql_query("INSERT INTO `users` SET
            `name` = '" . mysql_real_escape_string($reg_nick) . "',
            `name_lat` = '" . mysql_real_escape_string($lat_nick) . "',
            `password` = '" . mysql_real_escape_string($pass) . "',
            `imname` = '$reg_name',
            `about` = '$reg_about',
			`mail` = '$reg_mail',
            `sex` = '$reg_sex',
			`dayb` = '$reg_dayb',
			`monthb` = '$reg_monthb',
			`yearofbirth` = '$reg_yearofbirth',
			`live` = '$reg_live',
			`icq` = '$reg_icq',
			`skype` = '$reg_skype',
			`jabber` = '$reg_jabber',
			`www` = '$reg_www',
			`mibile` = '$reg_mibile',
            `rights` = '0',
            `ip` = '" . core::$ip . "',
            `ip_via_proxy` = '" . core::$ip_via_proxy . "',
            `browser` = '" . mysql_real_escape_string($agn) . "',
            `datereg` = '" . time() . "',
            `lastdate` = '" . time() . "',
            `sestime` = '" . time() . "',
            `preg` = '$preg',
            `set_user` = '',
            `set_forum` = '',
            `set_mail` = '',
            `smileys` = ''
        ") or exit(__LINE__ . ': ' . mysql_error());
        $usid = mysql_insert_id();

        // Отправка системного сообщения
        $set_mail = unserialize($set['setting_mail']);
        if (!isset($set_mail['message_include'])) {
            $set_mail['message_include'] = 0;
        }

        if ($set_mail['message_include']) {
            $array = array('{LOGIN}', '{TIME}');
            $array_replace = array($reg_nick, '{TIME=' . time() . '}');

            if (empty($set['them_message']))
                $set['them_message'] = $lng_mail['them_message'];
            if (empty($set['reg_message']))
                $set['reg_message'] = $lng['hi'] . ", {LOGIN}\r\n" . $lng_mail['pleased_see_you'] . "\r\n" . $lng_mail['come_my_site'] . "\r\n" . $lng_mail['respectfully_yours'];
            $theme = str_replace($array, $array_replace, $set['them_message']);
            $system = str_replace($array, $array_replace, $set['reg_message']);
            mysql_query("INSERT INTO `cms_mail` SET
			    `user_id` = '0',
			    `from_id` = '" . $usid . "',
			    `text` = '" . mysql_real_escape_string($system) . "',
			    `time` = '" . time() . "',
			    `sys` = '1',
			    `them` = '" . mysql_real_escape_string($theme) . "'
			");
        }

        echo'<div class="menu"><p><h3>' . $lng_reg['you_registered'] . '</h3>' . $lng_reg['your_id'] . ': <b>' . $usid . '</b><br/>' . $lng_reg['your_login'] . ': <b>' . $reg_nick . '</b><br/>' . $lng_reg['your_password'] . ': <b>' . $reg_pass . '</b></p>' .
            '<p><h3>' . $lng_reg['your_link'] . '</h3><input type="text" value="' . $set['homeurl'] . '/login.php?id=' . $usid . '&amp;p=' . $reg_pass . '" /><br/>';
        if ($set['mod_reg'] == 1) {
            echo '<p><span class="red"><b>' . $lng_reg['moderation_note'] . '</b></span></p>';
        } else {
            echo '<br /><a href="login.php?id=' . $usid . '&amp;p=' . $reg_pass . '">' . $lng_reg['enter'] . '</a><br/><br/>';
        }
        echo '</p></div>';
        require('incfiles/end.php');
        exit;
    }
}

/*
-----------------------------------------------------------------
Форма регистрации
-----------------------------------------------------------------
*/
if ($set['mod_reg'] == 1) echo '<div class="rmenu"><p>' . $lng_reg['moderation_warning'] . '</p></div>';
echo'<form action="registration.php" method="post">
<div class="gmenu">' .
    '<p><h3>' . $lng_reg['login'] . '</h3>' .
    (isset($error['login']) ? '<span class="red"><small>' . implode('<br />', $error['login']) . '</small></span><br />' : '') .
    '<input type="text" name="nick" maxlength="15" value="' . htmlspecialchars($reg_nick) . '"' . (isset($error['login']) ? ' style="background-color: #FFCCCC"' : '') . '/><br />' .
    '<div class = "sub">' . $lng_reg['login_help'] . '</div></p>' .
    '<p><h3>' . $lng_reg['password'] . '</h3>' .
    (isset($error['password']) ? '<span class="red"><small>' . implode('<br />', $error['password']) . '</small></span><br />' : '') .
    '<input type="text" name="password" maxlength="20" value="' . htmlspecialchars($reg_pass) . '"' . (isset($error['password']) ? ' style="background-color: #FFCCCC"' : '') . '/><br/>' .
    '<div class = "sub">' . $lng_reg['password_help'] . '</div></p>' .
	
	'<p><h3>Ваш E-Mail адрес</h3>' .
    (isset($error['mail']) ? '<span class="red"><small>' . implode('<br />', $error['mail']) . '</small></span><br />' : '') .
    '<input type="text" name="mail" maxlength="20" value="' . htmlspecialchars($reg_mail) . '"' . (isset($error['mail']) ? ' style="background-color: #FFCCCC"' : '') . '/><br/>' .
    '<div class = "sub">' . $lng_reg['email_help'] . '</div></p>' .
	
    '</div>' .
    '<div class="phdr"><b>' . $lng_reg['prof_data'] . '</b></div>' .
	'<div class="menu">' .
    
	'<p><h3>' . $lng_reg['name'] . '</h3>' .
	(isset($error['imname']) ? '<span class="red"><small>' . implode('<br />', $error['imname']) . '</small></span><br />' : '') .
    '<input type="text" name="imname" maxlength="30" value="' . htmlspecialchars($reg_name) . '"' . (isset($error['imname']) ? ' style="background-color: #FFCCCC"' : '') . ' /><br />' .
    '<div class = "sub">' . $lng_reg['name_help'] . '</div></p>' .
	
	'<p><h3>' . $lng_reg['sex'] . '</h3>' .
    (isset($error['sex']) ? '<span class="red"><small>' . $error['sex'] . '</small></span><br />' : '') .
    '<select name="sex"' . (isset($error['sex']) ? ' style="background-color: #FFCCCC"' : '') . '>' .
    '<option value="?">-?-</option>' .
    '<option value="m"' . ($reg_sex == 'm' ? ' selected="selected"' : '') . '>' . $lng_reg['sex_m'] . '</option>' .
    '<option value="zh"' . ($reg_sex == 'zh' ? ' selected="selected"' : '') . '>' . $lng_reg['sex_w'] . '</option>' .
    '</select></p>' .
    
	'<p><h3>' . $lng_reg['birth_date'] . '</h3>' .

	(isset($error['dayb']) ? '<span class="red"><small>' . implode('<br />', $error['dayb']) . '</small></span><br />' : '') .
	(isset($error['monthb']) ? '<span class="red"><small>' . implode('<br />', $error['monthb']) . '</small></span><br />' : '') .
	(isset($error['yearofbirth']) ? '<span class="red"><small>' . implode('<br />', $error['yearofbirth']) . '</small></span><br />' : '') .
    '<input type="text" value="' . $user['dayb'] . '" size="2" maxlength="2" name="dayb" pattern="^[ 0-9]+$"' . (isset($error['dayb']) ? ' style="background-color: #FFCCCC"' : '') . ' />.' .
    '<input type="text" value="' . $user['monthb'] . '" size="2" maxlength="2" name="monthb" pattern="^[ 0-9]+$"' . (isset($error['monthb']) ? ' style="background-color: #FFCCCC"' : '') . ' />.' .
    '<input type="text" value="' . $user['yearofbirth'] . '" size="4" maxlength="4" name="yearofbirth" pattern="^[ 0-9]+$"' . (isset($error['yearofbirth']) ? ' style="background-color: #FFCCCC"' : '') . ' /><br /></p>' .
	
	'<p><h3>' . $lng_reg['live'] . '</h3>' .
	(isset($error['live']) ? '<span class="red"><small>' . implode('<br />', $error['live']) . '</small></span><br />' : '') .
    '<input type="text" name="live" maxlength="20" value="' . htmlspecialchars($reg_live) . '"' . (isset($error['live']) ? ' style="background-color: #FFCCCC"' : '') . '/><br/>' .
	'<div class = "sub">' . $lng_reg['name_help'] . '</div></p>' .
	
	'<p><h3>' . $lng_reg['about'] . '</h3>' .
	(isset($error['about']) ? '<span class="red"><small>' . implode('<br />', $error['about']) . '</small></span><br />' : '') .
    '<textarea rows="3" name="about">' . htmlspecialchars($reg_about) . '</textarea><br />' .
    '<div class = "sub">' . $lng_reg['about_help'] . '</div></p></div>' .
	
	'<div class = "phdr"><b>' . $lng_reg['contacts'] . '</b></div>' .
	'<div class="menu">' .
	
	'<p><b>' . $lng_reg['mibile'] . '</b><br/>' .
    '<input type="text" name="mibile" maxlength="30" value="' . htmlspecialchars($reg_mibile) . '"/><br /></p>' .
	'<p><b>' . $lng_reg['icq'] . '</b><br/>' .
    '<input type="text" name="icq" maxlength="30" value="' . htmlspecialchars($reg_icq) . '"/><br /></p>' .
	'<p><b>' . $lng_reg['skype'] . '</b><br/>' .
    '<input type="text" name="skype" maxlength="30" value="' . htmlspecialchars($reg_skype) . '"/><br /></p>' .
	'<p><b>' . $lng_reg['jabber'] . '</b><br/>' .
    '<input type="text" name="jabber" maxlength="30" value="' . htmlspecialchars($reg_jabber) . '"/><br /></p>' .
	'<p><b>' . $lng_reg['www'] . '</b><br/>' .
    '<input type="text" name="www" maxlength="30" value="' . htmlspecialchars($reg_www) . '"/><br /></p>' .
	'<div class = "sub" style = "color:green">' . $lng_reg['about_contacts'] . '</div>' .
	'</div>' .
	
    '<div class="gmenu"><p>' .
    '<h3>' . $lng_reg['captcha'] . '</h3>' .
    '<img src="captcha.php?r=' . rand(1000, 9999) . '" alt="' . $lng_reg['captcha'] . '" border="1"/><br />' .
    (isset($error['captcha']) ? '<span class="red"><small>' . $error['captcha'] . '</small></span><br />' : '') .
    '<input type="text" size="5" maxlength="5"  name="captcha" ' . (isset($error['captcha']) ? ' style="background-color: #FFCCCC"' : '') . '/><br />' .
    '<small>' . $lng_reg['captcha_help'] . '</small></p>' .
    '<p><input type="submit" name="submit" value="' . $lng_reg['registration'] . '"/></p></div></form>' .
    '<div class="phdr"><small>' . $lng_reg['registration_terms'] . '</small></div>';

require('incfiles/end.php');