DROP TABLE IF EXISTS `cms_ads`;

CREATE TABLE `cms_ads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `view` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `layout` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `count_link` int(10) unsigned NOT NULL DEFAULT '0',
  `name` text NOT NULL,
  `link` text NOT NULL,
  `to` int(10) unsigned NOT NULL DEFAULT '0',
  `color` varchar(10) NOT NULL DEFAULT '',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `day` int(10) unsigned NOT NULL DEFAULT '0',
  `mesto` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `bold` tinyint(1) NOT NULL DEFAULT '0',
  `italic` tinyint(1) NOT NULL DEFAULT '0',
  `underline` tinyint(1) NOT NULL DEFAULT '0',
  `show` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO cms_ads VALUES("1","1","0","0","1","0","Yoshlik.Net - Siz Kutgan Portal","http://yoshlik.net","0","ff0000","1475636289","0","1","1","1","0","0");



DROP TABLE IF EXISTS `cms_album_cat`;

CREATE TABLE `cms_album_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sort` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(40) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `password` varchar(20) NOT NULL DEFAULT '',
  `access` tinyint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `access` (`access`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_album_comments`;

CREATE TABLE `cms_album_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sub_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `reply` text NOT NULL,
  `attributes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_album_downloads`;

CREATE TABLE `cms_album_downloads` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `file_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_album_files`;

CREATE TABLE `cms_album_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `album_id` int(10) unsigned NOT NULL,
  `description` text NOT NULL,
  `img_name` varchar(100) NOT NULL DEFAULT '',
  `tmb_name` varchar(100) NOT NULL DEFAULT '',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `comments` tinyint(1) NOT NULL DEFAULT '1',
  `comm_count` int(10) unsigned NOT NULL DEFAULT '0',
  `access` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `vote_plus` int(11) NOT NULL DEFAULT '0',
  `vote_minus` int(11) NOT NULL DEFAULT '0',
  `views` int(10) unsigned NOT NULL DEFAULT '0',
  `downloads` int(10) unsigned NOT NULL DEFAULT '0',
  `unread_comments` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `album_id` (`album_id`),
  KEY `access` (`access`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_album_views`;

CREATE TABLE `cms_album_views` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `file_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_album_votes`;

CREATE TABLE `cms_album_votes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `file_id` int(10) unsigned NOT NULL DEFAULT '0',
  `vote` tinyint(2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `file_id` (`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_ban_ip`;

CREATE TABLE `cms_ban_ip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ip1` bigint(11) NOT NULL DEFAULT '0',
  `ip2` bigint(11) NOT NULL DEFAULT '0',
  `ban_type` tinyint(4) NOT NULL DEFAULT '0',
  `link` varchar(100) NOT NULL,
  `who` varchar(25) NOT NULL,
  `reason` text NOT NULL,
  `date` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip1` (`ip1`),
  UNIQUE KEY `ip2` (`ip2`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_ban_users`;

CREATE TABLE `cms_ban_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `ban_time` int(11) NOT NULL DEFAULT '0',
  `ban_while` int(11) NOT NULL DEFAULT '0',
  `ban_type` tinyint(4) NOT NULL DEFAULT '1',
  `ban_who` varchar(30) NOT NULL DEFAULT '',
  `ban_ref` int(11) NOT NULL DEFAULT '0',
  `ban_reason` text NOT NULL,
  `ban_raz` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `ban_time` (`ban_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_contact`;

CREATE TABLE `cms_contact` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `from_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `friends` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ban` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `man` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_user` (`user_id`,`from_id`),
  KEY `time` (`time`),
  KEY `ban` (`ban`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO cms_contact VALUES("1","2","1","1475595863","1","0","0","0");
INSERT INTO cms_contact VALUES("2","1","2","1475595863","1","0","0","0");



DROP TABLE IF EXISTS `cms_counters`;

CREATE TABLE `cms_counters` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sort` int(10) NOT NULL DEFAULT '1',
  `name` varchar(30) NOT NULL,
  `link1` text NOT NULL,
  `link2` text NOT NULL,
  `mode` tinyint(4) NOT NULL DEFAULT '1',
  `switch` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO cms_counters VALUES("1","1","live","<center><!--LiveInternet counter--><script type=\"text/javascript\"><!--\r\ndocument.write(\"<a href=\'//www.liveinternet.ru/click\' \"+\r\n\"target=_blank><img src=\'//counter.yadro.ru/hit?t26.6;r\"+\r\nescape(document.referrer)+((typeof(screen)==\"undefined\")?\"\":\r\n\";s\"+screen.width+\"*\"+screen.height+\"*\"+(screen.colorDepth?\r\nscreen.colorDepth:screen.pixelDepth))+\";u\"+escape(document.URL)+\r\n\";\"+Math.random()+\r\n\"\' alt=\'\' title=\'LiveInternet: показано число посетителей за\"+\r\n\" сегодня\' \"+\r\n\"border=\'0\' width=\'88\' height=\'15\'><\\/a>\")\r\n//--></script><!--/LiveInternet-->\r\n</center>","<center><!--LiveInternet counter--><script type=\"text/javascript\"><!--\r\ndocument.write(\"<a href=\'//www.liveinternet.ru/click\' \"+\r\n\"target=_blank><img src=\'//counter.yadro.ru/hit?t26.6;r\"+\r\nescape(document.referrer)+((typeof(screen)==\"undefined\")?\"\":\r\n\";s\"+screen.width+\"*\"+screen.height+\"*\"+(screen.colorDepth?\r\nscreen.colorDepth:screen.pixelDepth))+\";u\"+escape(document.URL)+\r\n\";\"+Math.random()+\r\n\"\' alt=\'\' title=\'LiveInternet: показано число посетителей за\"+\r\n\" сегодня\' \"+\r\n\"border=\'0\' width=\'88\' height=\'15\'><\\/a>\")\r\n//--></script><!--/LiveInternet-->\r\n</center>","1","1");



DROP TABLE IF EXISTS `cms_forum_files`;

CREATE TABLE `cms_forum_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat` int(10) unsigned NOT NULL DEFAULT '0',
  `subcat` int(10) unsigned NOT NULL DEFAULT '0',
  `topic` int(10) unsigned NOT NULL DEFAULT '0',
  `post` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `filename` text NOT NULL,
  `filetype` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `dlcount` int(10) unsigned NOT NULL DEFAULT '0',
  `del` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `cat` (`cat`),
  KEY `subcat` (`subcat`),
  KEY `topic` (`topic`),
  KEY `post` (`post`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_forum_rdm`;

CREATE TABLE `cms_forum_rdm` (
  `topic_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`topic_id`,`user_id`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_forum_vote`;

CREATE TABLE `cms_forum_vote` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(2) NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `topic` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(200) NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `topic` (`topic`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_forum_vote_users`;

CREATE TABLE `cms_forum_vote_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `topic` int(11) NOT NULL,
  `vote` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `topic` (`topic`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_library_comments`;

CREATE TABLE `cms_library_comments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sub_id` int(11) unsigned NOT NULL,
  `time` int(11) NOT NULL,
  `user_id` int(11) unsigned NOT NULL,
  `text` text NOT NULL,
  `reply` text,
  `attributes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_library_rating`;

CREATE TABLE `cms_library_rating` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `st_id` int(11) NOT NULL,
  `point` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`st_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_mail`;

CREATE TABLE `cms_mail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `from_id` int(10) unsigned NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `read` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sys` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `delete` int(10) unsigned NOT NULL DEFAULT '0',
  `file_name` varchar(100) NOT NULL DEFAULT '',
  `count` int(10) NOT NULL DEFAULT '0',
  `size` int(10) NOT NULL DEFAULT '0',
  `them` varchar(100) NOT NULL DEFAULT '',
  `spam` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `from_id` (`from_id`),
  KEY `time` (`time`),
  KEY `read` (`read`),
  KEY `sys` (`sys`),
  KEY `delete` (`delete`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO cms_mail VALUES("1","2","1","Topaman bayiby. :D","1475594793","1","0","0","","0","0","","0");
INSERT INTO cms_mail VALUES("2","1","2","xaxaxa","1475595863","0","0","0","","0","0","","0");
INSERT INTO cms_mail VALUES("3","0","1","К файлу в загрузках оставили комментарий. [url=http://uztivi.ru/download/komm.php?id=1]Смотреть[/url]","1475604161","1","1","0","","0","0","","0");



DROP TABLE IF EXISTS `cms_news`;

CREATE TABLE `cms_news` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  `text` text NOT NULL,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `refid` (`refid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO cms_news VALUES("1","1","","","1","1324717200");
INSERT INTO cms_news VALUES("2","1","test","teest","1","1475589389");



DROP TABLE IF EXISTS `cms_news_cat`;

CREATE TABLE `cms_news_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `realid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  `desc_enable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `realid` (`realid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO cms_news_cat VALUES("1","1","Shou-beznes","1");



DROP TABLE IF EXISTS `cms_news_comments`;

CREATE TABLE `cms_news_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refid` int(10) unsigned NOT NULL,
  `time` int(11) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `text` text NOT NULL,
  `reply` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `time` (`time`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_news_rating`;

CREATE TABLE `cms_news_rating` (
  `id_rate` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `news` int(11) NOT NULL,
  `user_id` int(11) unsigned NOT NULL,
  `golos` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`id_rate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_sessions`;

CREATE TABLE `cms_sessions` (
  `session_id` char(32) NOT NULL DEFAULT '',
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `browser` varchar(255) NOT NULL DEFAULT '',
  `lastdate` int(10) unsigned NOT NULL DEFAULT '0',
  `sestime` int(10) unsigned NOT NULL DEFAULT '0',
  `views` int(10) unsigned NOT NULL DEFAULT '0',
  `movings` smallint(5) unsigned NOT NULL DEFAULT '0',
  `place` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`session_id`),
  KEY `lastdate` (`lastdate`),
  KEY `place` (`place`(10))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO cms_sessions VALUES("0e5ba5f3e0c58a66957e9dc78d8586c2","136702766","3161574796","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475580255","1475580015","0","12","load");
INSERT INTO cms_sessions VALUES("003b043499daf7bd414916388fac6c85","136701892","3161574796","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475580255","1475580087","0","7","load");
INSERT INTO cms_sessions VALUES("d1431bfc6d220eef415822756d58eaf0","136703479","3161574796","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475580255","1475580087","0","8","load");
INSERT INTO cms_sessions VALUES("5cb83462d839ec627086cf96370c1800","136703392","3161574796","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475580255","1475580087","0","8","load");
INSERT INTO cms_sessions VALUES("7cbbb90e26b0dec81be385ec53678144","136703282","3161574796","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475580252","1475580087","0","7","load");
INSERT INTO cms_sessions VALUES("28bc432e888126589b99732782f32402","3648409385","0","Mozilla/5.0 (Linux; Android 5.1; 4Good S450m 4G Build/LMY47D; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/43.0.2357.121 Mobile Safar","1475594684","1475594567","0","6","registration");
INSERT INTO cms_sessions VALUES("31c1e9b104dd7f09cc6d3f220b7919b7","2264506225","0","Not Recognised","1475587131","1475587131","0","0","mainpage");
INSERT INTO cms_sessions VALUES("6ceaf8160a95ec39e537fa1b0b3b5d4a","2365591136","1539326892","Opera Mini: Mozilla/5.0 (Linux; U; Android 2.3.6; ru-ru; GT-I8160 Build/GINGERBREAD) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1","1475594032","1475593992","0","4","login");
INSERT INTO cms_sessions VALUES("0f5843f6252b60e2a701997a959693cc","531452346","0","Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36","1475594127","1475594127","0","0","mainpage");
INSERT INTO cms_sessions VALUES("64f2cde01ce4bf59f609ae1869f5486d","1385291624","2956686889","Opera Mini: Mozilla/5.0 (Linux; U; Android 4.2.2; ru-ru; GT-I9105 Build/JDQ39) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30","1475594173","1475594154","0","1","loadview");
INSERT INTO cms_sessions VALUES("362756724fe515043a0d59c7031c7880","2365591172","3161574700","Opera Mini: NokiaN82","1475594179","1475594179","0","0","mainpage");
INSERT INTO cms_sessions VALUES("59f7f9939634c6b8b6ad0696ba4ddb8a","2834026099","3161573816","Mozilla/5.0 (Linux; U; Android 4.2.2; en-US; GT-I8200 Build/JDQ39) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.5.725 U3/0.8.0 Mo","1475594232","1475594232","0","0","mainpage");
INSERT INTO cms_sessions VALUES("2c43edd5bff0d10356787acb9547a5ce","1607850583","3161575990","UCWEB/2.0 (MIDP-2.0; U; Adr 2.3.6; ru; GT-S6802) U2/1.0.0 UCBrowser/9.2.0.419 U2/1.0.0 Mobile","1475594375","1475594375","0","0","mainpage");
INSERT INTO cms_sessions VALUES("e128e8f558fc51642bfedad240c7bd09","136702766","3161575991","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475595812","1475595796","0","4","mainpage");
INSERT INTO cms_sessions VALUES("7db860838f2ed6f36b6d5c81152055be","136703392","3161575991","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475595812","1475595811","0","3","mainpage");
INSERT INTO cms_sessions VALUES("aec70a9abb02cdd10f95b239248e2a70","136701892","3161575991","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475595812","1475595812","0","1","online");
INSERT INTO cms_sessions VALUES("ec11ac634156c43d87ea5f3d9fd79024","136703282","3161575991","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475595812","1475595811","0","2","mainpage");
INSERT INTO cms_sessions VALUES("59b4c3f56ef06416a173d924814608c7","136703479","3161575991","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475595812","1475595811","0","3","mainpage");
INSERT INTO cms_sessions VALUES("ea344faa322ad2f2da1d42cdf4876aa2","136703392","3161574296","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475594493","1475594440","0","3","news");
INSERT INTO cms_sessions VALUES("e7eae92359dbe8d4e4b1f79fa50f9eb1","136702766","3161574296","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475594493","1475594440","0","5","news");
INSERT INTO cms_sessions VALUES("cfbf3a7327bf1bac8f0478a01d8f2427","136701892","3161574296","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475594493","1475594440","0","3","news");
INSERT INTO cms_sessions VALUES("a1516398ef4b53e144bea3da2af3d749","136703282","3161574296","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475594493","1475594486","0","1","news");
INSERT INTO cms_sessions VALUES("b383aae9f533c00e5786c6ef47e6c85a","136703479","3161574296","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475594494","1475594494","0","0","news");
INSERT INTO cms_sessions VALUES("d05775373e7f4a744bbe3c225d37d8b0","1607850607","3161575988","UCWEB/2.0 (MIDP-2.0; U; Adr 6.3.3; ru; IQ444_|_ShoXRuZ&quot;\Z) U2/1.0.0 UCBrowser/8.8.1.359 U2/1.0.0 Mobile","1475594557","1475594557","0","0","mainpage");
INSERT INTO cms_sessions VALUES("8b43a03ac18a1d55375c1849dbe4939c","2365591166","3161573224","Opera Mini: Nokia6303iclassic/06.61","1475595092","1475595092","0","1","mainpage");
INSERT INTO cms_sessions VALUES("b314e40e2249faf67c5115f8ec3a1cf9","1607850598","628020778","UCWEB/2.0 (MIDP-2.0; U; Adr 4.4.2; ru; LG-F180L) U2/1.0.0 UCBrowser/10.7.8.806 U2/1.0.0 Mobile","1475594992","1475594992","0","1","online");
INSERT INTO cms_sessions VALUES("6684f8c33fc5a8328f391df65dbd90fb","2834026406","3161575994","UCWEB/2.0 (Java; U; MIDP-2.0; en-US; SAMSUNG-GT-S5380D) U2/1.0.0 UCBrowser/9.5.0.449 U2/1.0.0 Mobile UNTRUSTED/1.0","1475594677","1475594677","0","0","mainpage");
INSERT INTO cms_sessions VALUES("8230d897cdd05de13294afa4bb329f9d","2365591467","3161572904","Opera Mini: NokiaC2-03/2.0 (07.65) Profile/MIDP-2.1 Configuration/CLDC-1.1  UNTRUSTED/1.0","1475594717","1475594717","0","0","mainpage");
INSERT INTO cms_sessions VALUES("799ea045da23f157ac712ceb4ae3e771","2834023555","628019932","NokiaX2-02/2.0 (11.79) Profile/MIDP-2.1 Configuration/CLDC-1.1 UCWEB/2.0 (Java; U; MIDP-2.0; en-US; NokiaX2-02) U2/1.0.0 UCBrowser/9.5.0.449 U2/1.0.0 ","1475594766","1475594766","0","0","mainpage");
INSERT INTO cms_sessions VALUES("740be05e94dea1e53e7db2b8e68c1f87","136703466","3161575332","NokiaX2-00/5.0 (08.25) Profile/MIDP-2.1 Configuration/CLDC-1.1 UCWEB/2.0 (Java; U; MIDP-2.0; en-US; NokiaX2-00) U2/1.0.0 UCBrowser/9.5.0.449 U2/1.0.0 ","1475594835","1475594806","0","1","online");
INSERT INTO cms_sessions VALUES("e943506fcc34756b3d11be299f675cd0","2834023808","628020386","Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; Desktop) AppleWebKit/534.13 (KHTML, like Gecko) UCBrowser/9.5.0.449","1475595069","1475595041","0","2","online");
INSERT INTO cms_sessions VALUES("eed3bbaf78d0fb257b1ced90dc9ed8a8","3588643945","0","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.143 Safari/537.36","1475595268","1475595268","0","0","mainpage");
INSERT INTO cms_sessions VALUES("4af9af1fd39fc5b3579499b701f7bd65","1607850584","628019746","UCWEB/2.0 (MIDP-2.0; U; Adr 4.4.2; ru; UZTE_GRAND_V7) U2/1.0.0 UCBrowser/10.2.0.584 U2/1.0.0 Mobile","1475595622","1475595622","0","0","mainpage");
INSERT INTO cms_sessions VALUES("60c99b7a863163bddc5fd79a88c09f4b","2365591247","1412854500","Opera Mini: NokiaX2-00","1475595773","1475595773","0","0","mainpage");
INSERT INTO cms_sessions VALUES("0cb6459b39bbc8360963c9ce0a03ba65","136702533","3588643848","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A093 Build/KOT49H) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/11.0.0.828 U3/0.","1475595852","1475595852","0","0","mainpage");
INSERT INTO cms_sessions VALUES("be26c18760d2d7160074edd5fdd66bd1","136702131","628020584","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/31.0.1650.63 Safari/537.36","1475600221","1475600221","0","1","mainpage");
INSERT INTO cms_sessions VALUES("1e7b891231e397dd7649cc0eb2fc5253","1607850589","3561488092","UCWEB/2.0 (MIDP-2.0; U; Adr 4.2.2; ru; A3) U2/1.0.0 UCBrowser/9.3.0.440 U2/1.0.0 Mobile","1475596979","1475596916","0","2","load");
INSERT INTO cms_sessions VALUES("0e7802a9c3d320df4faf11ba94370921","2365591151","3161574244","Opera Mini: Nokia2700c-2","1475597079","1475597005","0","4","login");
INSERT INTO cms_sessions VALUES("8807799ab6da5ec18242bd2ca7b9718b","2834023643","3161575312","UCWEB/2.0 (Java; U; MIDP-2.0; en-US; NokiaE72-1) U2/1.0.0 UCBrowser/9.5.0.449 U2/1.0.0 Mobile UNTRUSTED/1.0 3gpp-gba","1475597334","1475597334","0","0","mainpage");
INSERT INTO cms_sessions VALUES("0fef196d751eb6961e06202b18b93fa7","2365591087","1539326956","Opera Mini: Mozilla/5.0 (Linux; U; Android 2.3.6; ru-ru; GT-I8160 Build/GINGERBREAD) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1","1475597800","1475597779","0","3","login");
INSERT INTO cms_sessions VALUES("087bedaead72120f0cda9596d3152074","3645214071","0","Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)","1475598831","1475598831","0","0","mainpage");
INSERT INTO cms_sessions VALUES("06f08299d95a3a5f5ce81b757ed97af8","1607850598","628020836","NokiaX2-01/5.0 (08.70) Profile/MIDP-2.1 Configuration/CLDC-1.1 UCWEB/2.0 (Java; U; MIDP-2.0; ru; NokiaX2-01) U2/1.0.0 UCBrowser/9.5.0.449 U2/1.0.0 Mob","1475599139","1475599139","0","0","mainpage");
INSERT INTO cms_sessions VALUES("c9780057b653744a8bf65cf2b67c08a2","3161573304","0","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.100 Safari/534.30","1475600105","1475600105","0","0","mainpage");
INSERT INTO cms_sessions VALUES("c10bbaa446fa2a39ba2d9fd6b06824fa","3588644276","0","Opera/9.80 (Windows NT 5.1) Presto/2.12.388 Version/12.17","1475600179","1475600179","0","0","mainpage");
INSERT INTO cms_sessions VALUES("699d5d7d56fa20d9e7ee70a93ab6a70f","1607850532","2956668866","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; ZTE Blade L3 Build/KOT49H) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/11.0.5.850 U3/0.8","1475600235","1475600235","0","0","mainpage");
INSERT INTO cms_sessions VALUES("ba5bb6c42a22425e9834290f3b348b07","2365591315","1412854500","Opera Mini: NokiaX2-00","1475600266","1475600266","0","0","mainpage");
INSERT INTO cms_sessions VALUES("68911a989bb0e3ff586e253ee4f5fd55","1607850588","3161575997","UCWEB/2.0 (MIDP-2.0; U; Adr 4.4.2; ru; Lenovo_A536) U2/1.0.0 UCBrowser/9.2.0.419 U2/1.0.0 Mobile","1475600354","1475600354","0","0","mainpage");
INSERT INTO cms_sessions VALUES("cbf94b4bb26b7fdd1c8b7e44f5884669","2365591414","3114473543","Opera Mini: Nokia210.2/2.0 (06.09) Profile/MIDP-2.1 Configuration/CLDC-1.1","1475600365","1475600365","0","0","mainpage");
INSERT INTO cms_sessions VALUES("a136b280116480c19e822e3c9da94d61","1607850571","1841069344","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Lenovo TAB 2 A7-30HC Build/KOT49H) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/11.0.0.82","1475600411","1475600411","0","0","mainpage");
INSERT INTO cms_sessions VALUES("65543cda3bce08afc889b7feef4e6c28","1358696478","1358697539","Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)","1475600766","1475600766","0","0","mainpage");
INSERT INTO cms_sessions VALUES("7deb3572105e911e77d6c29633660f33","1841069434","0","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.116 Safari/537.36","1475600915","1475600915","0","0","mainpage");
INSERT INTO cms_sessions VALUES("207e0044a6b59f8538d96166cb82b76c","2365591047","3161575060","Opera Mini: NokiaC3-01","1475600927","1475600927","0","0","mainpage");
INSERT INTO cms_sessions VALUES("714012c84841ea72587c47244f4500b7","2365591471","1539326956","Opera Mini: Mozilla/5.0 (Linux; U; Android 2.3.6; ru-ru; GT-I8160 Build/GINGERBREAD) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1","1475602949","1475602855","0","4","login");
INSERT INTO cms_sessions VALUES("be06cb92a0c4190bb0ea389c24cfaa3f","136701821","3161572860","NokiaX2-00/5.0 (08.35) Profile/MIDP-2.1 Configuration/CLDC-1.1 Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; Desktop) AppleWebKit/534.13 (KHTML, lik","1475604298","1475604298","0","0","mainpage");
INSERT INTO cms_sessions VALUES("bab9f2a514fe2baa8587618bf0076a96","628020573","0","Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36","1475604370","1475604370","0","0","mainpage");
INSERT INTO cms_sessions VALUES("7b110dda9ee62496929367d7e490302a","2834026170","3161572892","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; GT-I9301I Build/KOT49H) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.9.0.731 U3/0.8.0 ","1475604449","1475604449","0","1","mainpage");
INSERT INTO cms_sessions VALUES("f6aebe11edf4a237458607cb984c0793","1607850549","2956657338","Mozilla/5.0 (Linux; U; Android 5.1; en-US; Tele2_Mini Build/LMY47I) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/11.0.0.828 U3/0.8.0 M","1475605252","1475605251","0","1","mainpage");
INSERT INTO cms_sessions VALUES("b4374001a2e44ad9be5074e816070caa","3588644857","0","UCWEB/2.0 (Symbian; U; S60 V3; ru; NokiaE72-1) U2/1.0.0 UCBrowser/9.2.0.336 U2/1.0.0 Mobile","1475605813","1475605813","0","0","mainpage");
INSERT INTO cms_sessions VALUES("97020fc15b908283053d42bfe9fc2236","1607850599","3588644857","UCWEB/2.0 (Symbian; U; S60 V3; ru; NokiaE72-1) U2/1.0.0 UCBrowser/9.2.0.336 U2/1.0.0 Mobile","1475605814","1475605814","0","0","mainpage");
INSERT INTO cms_sessions VALUES("c185bf05b54f47759dfc77b171ce891c","2365591350","1539326956","Opera Mini: Mozilla/5.0 (Linux; U; Android 2.3.6; ru-ru; GT-I8160 Build/GINGERBREAD) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1","1475607553","1475607370","0","3","mainpage");
INSERT INTO cms_sessions VALUES("e6958aacefe33d5fdaa5bdd40ad99b86","1607850607","628020492","NokiaC2-01/5.0 (11.10) Profile/MIDP-2.1 Configuration/CLDC-1.1 UCWEB/2.0 (Java; U; MIDP-2.0; ru; NokiaC2-01) U2/1.0.0 UCBrowser/9.5.0.449 U2/1.0.0 Mob","1475608582","1475608464","0","3","gallery");
INSERT INTO cms_sessions VALUES("78258bcb9ea36d52d491cbef9b704c2c","136702704","3161575995","Mozilla/5.0 (Linux; U; Android 4.2.2; en-US; GT-S7582 Build/JDQ39) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.9.0.731 U3/0.8.0 Mo","1475608753","1475608716","0","2","online");
INSERT INTO cms_sessions VALUES("40c8c53754635d9a6082eef79c64de55","1607850589","3161572692","Nokia5228/UCWEB8.6.0.180/50/352","1475608944","1475608868","0","2","load");
INSERT INTO cms_sessions VALUES("67ef19bc5d1f9f6894ce25f96ff35cc9","1607850606","3161575416","UCWEB/2.0 (MIDP-2.0; U; Adr 2.3.6; ru; GT-I9001) U2/1.0.0 UCBrowser/10.7.8.806 U2/1.0.0 Mobile","1475608870","1475608870","0","0","mainpage");
INSERT INTO cms_sessions VALUES("464b2f159800234a60ab6f9a3367be93","2365591432","3161573252","Opera Mini: SonyEricssonW660i","1475608943","1475608911","0","1","loadview");
INSERT INTO cms_sessions VALUES("ec3079a43239a166322490d1849a79a3","1607850532","1541254881","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; ZTE Blade L3 Build/KOT49H) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/11.0.5.850 U3/0.8","1475608995","1475608995","0","1","mainpage");
INSERT INTO cms_sessions VALUES("258cc880e4eb0b69e4516771e218a9a8","2834026222","3588644353","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Beeline Smart 3 Build/KOT49H) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.4.1.565 U3/","1475609514","1475609514","0","1","mainpage");
INSERT INTO cms_sessions VALUES("afe3d8745050a34e0cff996cc3930387","1607850580","3161575032","Nokia311/5.0 (07.36) Profile/MIDP-2.1 Configuration/CLDC-1.1 UCWEB/2.0 (Java; U; MIDP-2.0; ru; Nokia311) U2/1.0.0 UCBrowser/9.5.0.449 U2/1.0.0 Mobile","1475609557","1475609557","0","0","mainpage");
INSERT INTO cms_sessions VALUES("4f72cdf928a75bd85e7cca3b19e87082","2365591473","3114473561","Opera Mini: NokiaX2-00","1475609697","1475609697","0","0","mainpage");
INSERT INTO cms_sessions VALUES("4f531a9ea77936645a4806f8244c2379","1607850577","3579285901","UCWEB/2.0 (MIDP-2.0; U; Adr 4.2.1; ru; X-tremer) U2/1.0.0 UCBrowser/10.1.1.570 U2/1.0.0 Mobile","1475609755","1475609755","0","0","mainpage");
INSERT INTO cms_sessions VALUES("34b258c10e4ace989f32468fb2fdceeb","3105535183","531453070","Opera Mini: NokiaX2-00/5.0 (08.35) Profile/MIDP-2.1 Configuration/CLDC-1.1 UCWEB/2.0 (Java; U; MIDP-2.0; ru; NokiaX2-00) U2/1.0.0 UCBrowser/9.5.0.449 U2/1.0.0 Mob","1475610532","1475610532","0","0","mainpage");
INSERT INTO cms_sessions VALUES("139f31969279ad3d5c7d94a2b3031ed5","1385291118","2956666229","Mozilla/5.0 (Linux; Android 5.1; Beeline Smart 5 Build/LMY47I) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.94 Mobile Safari/537.36 OPR/37.","1475610688","1475610672","0","2","mainpage");
INSERT INTO cms_sessions VALUES("f2b943442607291a43a1de3a74fe7994","136702279","1539326956","Mozilla/5.0 (Linux; U; Android 2.3.6; en-US; GT-I8160 Build/GINGERBREAD) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.9.8.770 U3/0.","1475613411","1475613411","0","1","mainpage");
INSERT INTO cms_sessions VALUES("d99312e641aa4fde9a778cbb762143e2","2365591291","1539326910","Opera Mini: Mozilla/5.0 (Linux; U; Android 2.3.6; ru-ru; GT-I8160 Build/GINGERBREAD) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1","1475618920","1475618920","0","0","mainpage");
INSERT INTO cms_sessions VALUES("0e2c89d585c0b992236c04934a163b25","2365591130","3161575656","Opera Mini: Mozilla/5.0 (SymbianOS/9.4; U; Series60/5.0 Nokia5800d-1/52.0.007; Profile/MIDP-2.1 Configuration/CLDC-1.1; ru) AppleWebKit/525 (KHTML, like Gecko) Br","1475631911","1475631911","0","0","mainpage");
INSERT INTO cms_sessions VALUES("13d34795d6fa14acff30a1ade68e72df","136702969","3161572916","Mozilla/5.0 (Linux; U; Android 5.0.1; en-US; LG-H324 Build/LRX21Y) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/11.0.5.850 U3/0.8.0 Mo","1475632739","1475632613","0","5","mainpage");
INSERT INTO cms_sessions VALUES("5d66110a7b800e4e888aabb6200a1954","136702899","628020518","Mozilla/5.0 (Linux; U; Android 4.3; en-US; 6016X Build/JLS36C) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/11.0.5.850 U3/0.8.0 Mobile","1475633034","1475633034","0","1","mainpage");
INSERT INTO cms_sessions VALUES("103d8bca2a6cc0c86481ae0bdce80c28","136702231","3161573252","Mozilla/5.0 (Linux; U; Android 5.0.1; en-US; LG-H502 Build/LRX21Y) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/11.0.5.850 U3/0.8.0 Mo","1475633734","1475633734","0","1","mainpage");
INSERT INTO cms_sessions VALUES("5c84bac06a0cadde1a32e330fa996526","2834023643","3161575986","UCWEB/2.0 (Java; U; MIDP-2.0; en-US; NokiaE72-1) U2/1.0.0 UCBrowser/9.5.0.449 U2/1.0.0 Mobile UNTRUSTED/1.0 3gpp-gba","1475636170","1475636170","0","0","mainpage");
INSERT INTO cms_sessions VALUES("1e4474d78aaacc8b2d82d0f2d7a38d10","1607850603","3161573776","UCWEB/2.0 (MIDP-2.0; U; Adr 4.4.2; ru; 6012x) U2/1.0.0 UCBrowser/10.7.8.806 U2/1.0.0 Mobile","1475636246","1475636226","0","1","load");
INSERT INTO cms_sessions VALUES("f113c3964f734726a8811127abdb46ba","1607850590","3161575996","Nokia3110c/2.0 (07.21) Profile/MIDP-2.0 Configuration/CLDC-1.1 UCWEB/2.0 (Java; U; MIDP-2.0; ru; nokia3110c) U2/1.0.0 UCBrowser/8.9.0.251 U2/1.0.0 Mob","1475636242","1475636242","0","0","mainpage");
INSERT INTO cms_sessions VALUES("af697fa28477b201cc3d963dfc1879ba","1607850639","3161574692","UCWEB/2.0 (MIDP-2.0; U; Adr 4.4.4; ru; SM-J100H) U2/1.0.0 UCBrowser/9.2.0.419 U2/1.0.0 Mobile","1475636491","1475636491","0","0","mainpage");
INSERT INTO cms_sessions VALUES("2c1a8726abbbbc7447d35b94974beed7","2834023676","3161575996","Nokia6233/2.0 (05.60) Profile/MIDP-2.0 Configuration/CLDC-1.1 UNTRUSTED/1.0","1475636915","1475636883","0","2","online");
INSERT INTO cms_sessions VALUES("fdbdb9618b9348848910ed94d062f489","136702766","3161574968","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475637233","1475637190","0","3","registration");
INSERT INTO cms_sessions VALUES("0301b05367e24a55f1afd1b45986100d","136703282","3161574968","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475637233","1475637191","0","3","registration");
INSERT INTO cms_sessions VALUES("f97394288d47b2bb26e55f5c632ef4f7","136703479","3161574968","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475637233","1475637191","0","3","registration");
INSERT INTO cms_sessions VALUES("b1c24046b5abb4178678a9bcdde2baf5","136701892","3161574968","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475637233","1475637191","0","3","registration");
INSERT INTO cms_sessions VALUES("c335ed9aa6439d7c2d4fc467a45ac4b3","136703392","3161574968","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475637233","1475637191","0","3","registration");
INSERT INTO cms_sessions VALUES("deaad868bd72f906f8f1d376322b2e7f","136701892","3161573744","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475637306","1475637282","0","7","mainpage");
INSERT INTO cms_sessions VALUES("88f7e287e55308224936555ae9446f57","136702766","3161573744","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475637306","1475637282","0","7","mainpage");
INSERT INTO cms_sessions VALUES("97b7cc869161f5428c35d7f1bb863a85","136703479","3161573744","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475637306","1475637282","0","7","mainpage");
INSERT INTO cms_sessions VALUES("c4f38676fcb62997521725b485b716a4","136703392","3161573744","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475637306","1475637282","0","7","mainpage");
INSERT INTO cms_sessions VALUES("6f377b1533c770acb8316478ff1597bd","136703282","3161573744","Mozilla/5.0 (Linux; U; Android 4.4.2; en-US; Micromax A091 Build/A091) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8.0.718 U3/0.8.","1475637306","1475637282","0","6","mainpage");
INSERT INTO cms_sessions VALUES("c680f753afa582a154998528273541b9","136702969","3161573244","Mozilla/5.0 (Linux; U; Android 5.0.1; en-US; LG-H324 Build/LRX21Y) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/11.0.5.850 U3/0.8.0 Mo","1475637301","1475637301","0","1","mainpage");
INSERT INTO cms_sessions VALUES("403cea719b809a0385d104e8d20ee400","2365591242","3161575504","Opera Mini: NokiaN82","1475637386","1475637386","0","0","mainpage");
INSERT INTO cms_sessions VALUES("c5480c070c686a41fa2ff7ba5c979cf3","136702131","628019965","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/31.0.1650.63 Safari/537.36","1475637531","1475637530","0","1","mainpage");



DROP TABLE IF EXISTS `cms_settings`;

CREATE TABLE `cms_settings` (
  `key` tinytext NOT NULL,
  `val` text NOT NULL,
  PRIMARY KEY (`key`(30))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO cms_settings VALUES("active","1");
INSERT INTO cms_settings VALUES("admp","panel");
INSERT INTO cms_settings VALUES("antiflood","a:5:{s:4:\"mode\";i:2;s:3:\"day\";i:10;s:5:\"night\";i:30;s:7:\"dayfrom\";i:10;s:5:\"dayto\";i:22;}");
INSERT INTO cms_settings VALUES("clean_time","1475562335");
INSERT INTO cms_settings VALUES("copyright","Powered by SARVARBEK");
INSERT INTO cms_settings VALUES("email","sarvarbek1999@bk.ru");
INSERT INTO cms_settings VALUES("flsz","4000");
INSERT INTO cms_settings VALUES("gzip","1");
INSERT INTO cms_settings VALUES("homeurl","http://uztivi.ru");
INSERT INTO cms_settings VALUES("karma","a:6:{s:12:\"karma_points\";i:5;s:10:\"karma_time\";i:86400;s:5:\"forum\";i:20;s:4:\"time\";i:0;s:2:\"on\";i:1;s:3:\"adm\";i:0;}");
INSERT INTO cms_settings VALUES("lng","ru");
INSERT INTO cms_settings VALUES("mod_reg","2");
INSERT INTO cms_settings VALUES("mod_forum","2");
INSERT INTO cms_settings VALUES("mod_guest","2");
INSERT INTO cms_settings VALUES("mod_lib","2");
INSERT INTO cms_settings VALUES("mod_gal","2");
INSERT INTO cms_settings VALUES("mod_down_comm","1");
INSERT INTO cms_settings VALUES("mod_down","2");
INSERT INTO cms_settings VALUES("mod_lib_comm","1");
INSERT INTO cms_settings VALUES("mod_gal_comm","1");
INSERT INTO cms_settings VALUES("meta_desc","sarvarbek yusupov: M.Ok.Ru/Xitmuzik <br />\ntel number : +996770430012");
INSERT INTO cms_settings VALUES("meta_key","SARVARBEK");
INSERT INTO cms_settings VALUES("news","a:8:{s:4:\"view\";i:1;s:4:\"size\";i:200;s:8:\"quantity\";i:5;s:4:\"days\";i:3;s:6:\"breaks\";i:1;s:7:\"smileys\";i:1;s:4:\"tags\";i:1;s:3:\"kom\";i:1;}");
INSERT INTO cms_settings VALUES("reg_message","");
INSERT INTO cms_settings VALUES("setting_mail","");
INSERT INTO cms_settings VALUES("skindef","default");
INSERT INTO cms_settings VALUES("them_message","");
INSERT INTO cms_settings VALUES("timeshift","0");
INSERT INTO cms_settings VALUES("site_access","2");



DROP TABLE IF EXISTS `cms_users_data`;

CREATE TABLE `cms_users_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(30) NOT NULL DEFAULT '',
  `val` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `key` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_users_guestbook`;

CREATE TABLE `cms_users_guestbook` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sub_id` int(10) unsigned NOT NULL,
  `time` int(11) NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `text` text NOT NULL,
  `reply` text NOT NULL,
  `attributes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_users_iphistory`;

CREATE TABLE `cms_users_iphistory` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `user_ip` (`ip`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

INSERT INTO cms_users_iphistory VALUES("1","1","2365591529","0","1475562335");
INSERT INTO cms_users_iphistory VALUES("2","1","2365591529","1539326850","1475563785");
INSERT INTO cms_users_iphistory VALUES("3","1","2365591298","1539326903","1475581103");
INSERT INTO cms_users_iphistory VALUES("4","1","2365591379","1539326903","1475585461");
INSERT INTO cms_users_iphistory VALUES("5","1","2365591379","1539326858","1475586071");
INSERT INTO cms_users_iphistory VALUES("6","1","2365591111","1539326858","1475586169");
INSERT INTO cms_users_iphistory VALUES("7","1","2365591356","1539326892","1475588833");
INSERT INTO cms_users_iphistory VALUES("8","1","2365591136","1539326892","1475594458");
INSERT INTO cms_users_iphistory VALUES("9","1","2365591136","1539326956","1475594566");
INSERT INTO cms_users_iphistory VALUES("10","1","2365591252","1539326956","1475597096");
INSERT INTO cms_users_iphistory VALUES("11","1","2365591087","1539326956","1475598920");
INSERT INTO cms_users_iphistory VALUES("12","1","2365591343","1539326956","1475600269");
INSERT INTO cms_users_iphistory VALUES("13","1","2365591471","1539326956","1475603079");
INSERT INTO cms_users_iphistory VALUES("14","1","1385290639","1539326956","1475604161");
INSERT INTO cms_users_iphistory VALUES("15","1","2365591261","1539326956","1475607055");
INSERT INTO cms_users_iphistory VALUES("16","1","1385290665","1539326956","1475611033");
INSERT INTO cms_users_iphistory VALUES("17","1","2365591377","1539326956","1475613362");
INSERT INTO cms_users_iphistory VALUES("18","1","2365591044","1539326910","1475618485");
INSERT INTO cms_users_iphistory VALUES("19","1","2365591191","1539326861","1475636295");



DROP TABLE IF EXISTS `down_bookmarks`;

CREATE TABLE `down_bookmarks` (
  `user` int(11) NOT NULL,
  `file` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `downfiles`;

CREATE TABLE `downfiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(2) NOT NULL DEFAULT '0',
  `pathid` int(11) NOT NULL,
  `way` text NOT NULL,
  `name` text NOT NULL,
  `desc` text NOT NULL,
  `time` int(11) NOT NULL,
  `rating` varchar(3) NOT NULL DEFAULT '0',
  `gol` text NOT NULL,
  `count` int(11) NOT NULL DEFAULT '0',
  `size` int(11) NOT NULL DEFAULT '0',
  `login` text NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '1',
  `themeid` int(11) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `pathid` (`pathid`),
  KEY `time` (`time`),
  KEY `type_status` (`type`,`status`),
  FULLTEXT KEY `desc` (`desc`),
  FULLTEXT KEY `way` (`way`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `downkomm`;

CREATE TABLE `downkomm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fileid` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `text` text NOT NULL,
  `plus` int(11) NOT NULL,
  `minus` int(11) NOT NULL,
  `golos` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

INSERT INTO downkomm VALUES("1","1","1475604161","1","test","0","0","");



DROP TABLE IF EXISTS `download`;

CREATE TABLE `download` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL DEFAULT '0',
  `adres` text NOT NULL,
  `time` int(11) NOT NULL DEFAULT '0',
  `name` text NOT NULL,
  `type` varchar(4) NOT NULL DEFAULT '',
  `avtor` varchar(25) NOT NULL DEFAULT '',
  `ip` text NOT NULL,
  `soft` text NOT NULL,
  `text` text NOT NULL,
  `screen` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `refid` (`refid`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `downpath`;

CREATE TABLE `downpath` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL,
  `way` text NOT NULL,
  `name` text NOT NULL,
  `desc` text NOT NULL,
  `position` int(11) NOT NULL,
  `dost` int(11) NOT NULL DEFAULT '0',
  `types` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `ref` (`refid`),
  KEY `position` (`position`),
  FULLTEXT KEY `way` (`way`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

INSERT INTO downpath VALUES("1","0","MUZIKA/","МУЗЫКА","узбекский ,зарубежный,...","0","1","mp3");
INSERT INTO downpath VALUES("2","0","klip/","Музыкальные клипы","","0","1","3gp,mp4");
INSERT INTO downpath VALUES("3","0","kinolar/","Кино , Сериал , Трейлер","","0","1","3gp,mp4");
INSERT INTO downpath VALUES("4","0","zagruzki/","Бесплатной загрузки","","0","1","mp3");



DROP TABLE IF EXISTS `downscreen`;

CREATE TABLE `downscreen` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fileid` int(11) NOT NULL,
  `way` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

INSERT INTO downscreen VALUES("1","1","Teri-Meri_(xindcha).mp3.png");



DROP TABLE IF EXISTS `forum`;

CREATE TABLE `forum` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refid` int(10) unsigned NOT NULL DEFAULT '0',
  `type` char(1) NOT NULL DEFAULT '',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `from` varchar(25) NOT NULL DEFAULT '',
  `realid` int(3) NOT NULL DEFAULT '0',
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `soft` text NOT NULL,
  `text` text NOT NULL,
  `close` tinyint(1) NOT NULL DEFAULT '0',
  `close_who` varchar(25) NOT NULL DEFAULT '',
  `vip` tinyint(1) NOT NULL DEFAULT '0',
  `edit` text NOT NULL,
  `tedit` int(10) unsigned NOT NULL DEFAULT '0',
  `kedit` int(2) unsigned NOT NULL DEFAULT '0',
  `curators` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `type` (`type`),
  KEY `time` (`time`),
  KEY `close` (`close`),
  KEY `user_id` (`user_id`),
  FULLTEXT KEY `text` (`text`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO forum VALUES("1","0","f","0","0","","1","0","0","Свободное общение на любую тему","Общение","0","","0","","0","0","");
INSERT INTO forum VALUES("2","1","r","0","0","","2","0","0","","О разном","0","","0","","0","0","");
INSERT INTO forum VALUES("3","1","r","0","0","","1","0","0","","Знакомства","0","","0","","0","0","");
INSERT INTO forum VALUES("4","0","f","0","0","","2","0","0","","Жизнь ресурса","0","","0","","0","0","");
INSERT INTO forum VALUES("5","4","r","0","0","","1","0","0","","Новости","0","","0","","0","0","");
INSERT INTO forum VALUES("6","4","r","0","0","","2","0","0","","Предложения и пожелания","0","","0","","0","0","");
INSERT INTO forum VALUES("7","4","r","0","0","","3","0","0","","Разное","0","","0","","0","0","");
INSERT INTO forum VALUES("8","3","t","1260814062","1","JohnCMS","0","0","0","","Привет всем!","0","","0","","0","0","");
INSERT INTO forum VALUES("9","8","m","1260814062","1","JohnCMS","0","1270","0","Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.2.15 Version/10.10","Мы рады приветствовать Вас на нашем сайте :)\r\nДавайте знакомиться!","0","","0","","0","0","");



DROP TABLE IF EXISTS `gallery`;

CREATE TABLE `gallery` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `type` varchar(2) NOT NULL DEFAULT '',
  `avtor` varchar(25) NOT NULL DEFAULT '',
  `text` text NOT NULL,
  `name` text NOT NULL,
  `user` binary(1) NOT NULL DEFAULT '\0',
  `ip` text NOT NULL,
  `soft` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `type` (`type`),
  KEY `time` (`time`),
  KEY `avtor` (`avtor`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO gallery VALUES("2","0","1216913224","rz","","Картинки","","\0","","");
INSERT INTO gallery VALUES("3","2","1216913232","al","","Природа","","\0","","");
INSERT INTO gallery VALUES("4","2","1216913245","al","","Животные","","\0","","");
INSERT INTO gallery VALUES("5","2","1216913260","al","","Креатив","","\0","","");



DROP TABLE IF EXISTS `guest`;

CREATE TABLE `guest` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `adm` tinyint(1) NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(25) NOT NULL DEFAULT '',
  `text` text NOT NULL,
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `browser` tinytext NOT NULL,
  `admin` varchar(25) NOT NULL DEFAULT '',
  `otvet` text NOT NULL,
  `otime` int(10) unsigned NOT NULL DEFAULT '0',
  `edit_who` varchar(20) NOT NULL DEFAULT '',
  `edit_time` int(10) unsigned NOT NULL DEFAULT '0',
  `edit_count` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `ip` (`ip`),
  KEY `adm` (`adm`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO guest VALUES("1","1","1217060516","1","admin","Добро пожаловать в Админ Клуб!\r\nСюда имеют доступ ТОЛЬКО Модераторы и Администраторы.\r\nПростым пользователям доступ сюда закрыт.","2130706433","Opera/9.51","","","0","","0","0");
INSERT INTO guest VALUES("2","0","1217060536","1","admin","Добро пожаловать в Гостевую!","2130706433","Opera/9.51","admin","Проверка ответа Администратора","1217064021","","0","0");
INSERT INTO guest VALUES("3","0","1217061125","1","admin","Для зарегистрированных пользователей Гостевая поддерживает BBcode:\r\n[b]жирный[/b]\r\n[i]курсив[/i]\r\n[u]подчеркнутый[/u]\r\n[red]красный[/red]\r\n[green]зеленый[/green]\r\n[blue]синий[/blue]\r\n\r\nи ссылки:\r\nhttp://gazenwagen.com\r\n\r\nДля гостей, эти функции закрыты.","2130706433","Opera/9.51","","","0","","0","0");



DROP TABLE IF EXISTS `karma_users`;

CREATE TABLE `karma_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '',
  `karma_user` int(10) unsigned NOT NULL DEFAULT '0',
  `points` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `karma_user` (`karma_user`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `library_cats`;

CREATE TABLE `library_cats` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(200) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `dir` tinyint(1) NOT NULL DEFAULT '0',
  `pos` int(10) unsigned NOT NULL DEFAULT '0',
  `user_add` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `library_tags`;

CREATE TABLE `library_tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lib_text_id` int(10) unsigned NOT NULL DEFAULT '0',
  `tag_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `lib_text_id` (`lib_text_id`),
  KEY `tag_name` (`tag_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `library_texts`;

CREATE TABLE `library_texts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_id` int(10) unsigned NOT NULL DEFAULT '0',
  `text` mediumtext NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `announce` text,
  `uploader` varchar(100) NOT NULL DEFAULT '',
  `uploader_id` int(10) unsigned NOT NULL DEFAULT '0',
  `count_views` int(10) unsigned NOT NULL DEFAULT '0',
  `premod` tinyint(1) NOT NULL DEFAULT '0',
  `comments` tinyint(1) NOT NULL DEFAULT '0',
  `count_comments` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  FULLTEXT KEY `text` (`text`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `main`;

CREATE TABLE `main` (
  `key` tinytext NOT NULL,
  `val` text NOT NULL,
  PRIMARY KEY (`key`(30))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO main VALUES("status","1");
INSERT INTO main VALUES("amatn","80");
INSERT INTO main VALUES("ulimit","5");
INSERT INTO main VALUES("notfound","http://site.uz/empty.jpeg");
INSERT INTO main VALUES("onid","0");
INSERT INTO main VALUES("oncat","0");
INSERT INTO main VALUES("cat","1");
INSERT INTO main VALUES("cuser","1");



DROP TABLE IF EXISTS `news`;

CREATE TABLE `news` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `avt` varchar(25) NOT NULL DEFAULT '',
  `name` text NOT NULL,
  `text` text NOT NULL,
  `kom` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(25) NOT NULL DEFAULT '',
  `name_lat` varchar(40) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL DEFAULT '',
  `rights` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `failed_login` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `imname` varchar(50) NOT NULL DEFAULT '',
  `sex` varchar(2) NOT NULL DEFAULT '',
  `komm` int(10) unsigned NOT NULL DEFAULT '0',
  `postforum` int(10) unsigned NOT NULL DEFAULT '0',
  `postguest` int(10) unsigned NOT NULL DEFAULT '0',
  `yearofbirth` int(4) NOT NULL DEFAULT '0',
  `datereg` int(10) unsigned NOT NULL DEFAULT '0',
  `lastdate` int(10) unsigned NOT NULL DEFAULT '0',
  `mail` varchar(50) NOT NULL DEFAULT '',
  `icq` int(10) unsigned NOT NULL DEFAULT '0',
  `skype` varchar(50) NOT NULL DEFAULT '',
  `jabber` varchar(50) NOT NULL DEFAULT '',
  `www` varchar(50) NOT NULL DEFAULT '',
  `about` text NOT NULL,
  `live` varchar(100) NOT NULL DEFAULT '',
  `mibile` varchar(50) NOT NULL DEFAULT '',
  `status` varchar(100) NOT NULL DEFAULT '',
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `browser` text NOT NULL,
  `preg` tinyint(1) NOT NULL DEFAULT '0',
  `regadm` varchar(25) NOT NULL DEFAULT '',
  `mailvis` tinyint(1) NOT NULL DEFAULT '0',
  `dayb` int(2) NOT NULL DEFAULT '0',
  `monthb` int(2) NOT NULL DEFAULT '0',
  `sestime` int(10) unsigned NOT NULL DEFAULT '0',
  `total_on_site` int(10) unsigned NOT NULL DEFAULT '0',
  `lastpost` int(10) unsigned NOT NULL DEFAULT '0',
  `rest_code` varchar(32) NOT NULL DEFAULT '',
  `rest_time` int(10) unsigned NOT NULL DEFAULT '0',
  `movings` int(10) unsigned NOT NULL DEFAULT '0',
  `place` varchar(30) NOT NULL DEFAULT '',
  `set_user` text NOT NULL,
  `set_forum` text NOT NULL,
  `set_mail` text NOT NULL,
  `karma_plus` int(11) NOT NULL DEFAULT '0',
  `karma_minus` int(11) NOT NULL DEFAULT '0',
  `karma_time` int(10) unsigned NOT NULL DEFAULT '0',
  `karma_off` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `comm_count` int(10) unsigned NOT NULL DEFAULT '0',
  `comm_old` int(10) unsigned NOT NULL DEFAULT '0',
  `smileys` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name_lat` (`name_lat`),
  KEY `lastdate` (`lastdate`),
  KEY `place` (`place`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO users VALUES("1","admin","admin","27886b686f4a496b0a10be773c9252f3","9","0","","m","1","0","0","0","1475562335","1475637752","sarvarbek1999@bk.ru","0","","","http://uztivi.ru","","","","","1385287945","1539326861","Opera Mini: Mozilla/5.0 (Linux; U; Android 2.3.6; ru-ru; GT-I8160 Build/GINGERBREAD) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1","1","","0","0","0","1475635744","19792","1475636289","","0","19","mainpage","","","","0","0","1475562339","0","0","0","");
INSERT INTO users VALUES("2","IRFON","irfon","8cde92d96f07e549ffa9ad1ef2657b2a","0","0","","m","0","0","0","0","1475594684","1475594812","","0","","","","","","","","3648409385","0","Mozilla/5.0 (Linux; Android 5.1; 4Good S450m 4G Build/LMY47D; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/43.0.2357.121 Mobile Safar","1","","0","0","0","1475594684","128","1475594793","","0","7","mainpage","","","","0","0","1475594693","0","0","0","");



