<?php
/*
 * Генератор RSS лент
 */

class RssController extends Controller
{
    /*
     * Действие по умолчанию
     */
    public $defaultAction = 'post';

    /*
     * Макет страницы
     */
    public $layout = '';



    /*
     * Инициализация компонента
     */
    public function  init()
    {
        // Загружаем класс создания RSS лент
        Yii::import ('ext.RssGen');

        parent::init();
    }



    /*
     * Трансляция статей в RSS
     */
    public function actionPost ()
    {
        $rss = new RssGen;
        $rss->title = CHtml::encode (Yii::app ()->config->rss_title);
        $rss->link = $this->createAbsoluteUrl ('//');
        $rss->desctiption = nl2br (CHtml::encode (Yii::app ()->config->rss_description));
        
        $last_create_post = Yii::app ()->db->createCommand ()->select ('MAX(`create_time`) AS create_time')->from ('{{post}}')->queryRow ();
        $last_update_post = Yii::app ()->db->createCommand ()->select ('MAX(`update_time`) AS update_time')->from ('{{post}}')->queryRow ();

        $rss->pubDate = $last_create_post["create_time"];
        $rss->lastBuildDate = $last_update_post["update_time"];
        $rss->image = Yii::app ()->request->getBaseUrl (TRUE) . '/themes/' . Yii::app ()->theme->name . '/favicon.ico';

        foreach (Post::model ()->loadToRss ()->getData () as $post)
        {

            $item = new RssGenItem;
            
            $item->title = $post->title;
            $item->link = $this->createAbsoluteUrl ('//post/view', array ('id' => $post->id));
            $item->description = nl2br (bbCode::Format (Smile::Format (CHtml::encode ((Yii::app ()->config->give_in_rss == 'info') ? $post->info_content : $post->cut_content))));
            $item->pubDate = $post->create_time;
            $item->comments = $this->createAbsoluteUrl ('//post/view', array ('id' => $post->id, '#' => 'comment'));
            $item->author = CHtml::encode ($post->user->login);

            $rss->addItem ($item);
        }

        $rss->render ();
    }

    /*
     * Последние комментарии
     */
    public function actionLastComments ()
    {
        $rss = new RssGen;
        $rss->title = CHtml::encode ('Последние комментарии');
        $rss->link = $this->createAbsoluteUrl ('//');
        $rss->desctiption = nl2br (CHtml::encode ('Последние комментарии в формате RSS.
Подписывайтесь и будьте в курсе самых свежих отзывов читателей!'));

        $last_create_comment = Yii::app ()->db->createCommand ()->select ('MAX(`create_time`) AS create_time')->from ('{{comment}}')->queryRow ();

        $rss->pubDate = $rss->lastBuildDate = $last_create_comment["create_time"];
        $rss->image = Yii::app ()->request->getBaseUrl (TRUE) . '/themes/' . Yii::app ()->theme->name . '/favicon.ico';

        foreach (Comment::model ()->loadLastComments ()->getData () as $comment)
        {

            $item = new RssGenItem;

            $item->title = 'Комментарий #' . $comment->id;
            $item->link = $this->createAbsoluteUrl ('//post/view', array ('id' => $comment->id_post, '#' => $comment->id));
            $item->description = nl2br (bbCode::Format (Smile::Format (CHtml::encode ($comment->content)))) . '<br />
(К статье <a href="' . $this->createAbsoluteUrl ('//post/view', array ('id' => $comment->post->id)) . '">' . CHtml::encode ($comment->post->title) . '</a>).';
            $item->pubDate = $comment->create_time;
            $item->author = CHtml::encode ((($comment->login == NULL) ? $comment->user->login : $comment->login));

            $rss->addItem ($item);
        }

        $rss->render ();
    }

    /*
     * RSS для статей в определенной категории
     */
    public function actionCategory ($id)
    {
        $category = Category::model()->findByPk((int) $id);
        if ($category === null)
            throw new CHttpException(404, 'Этой категории не существует!');

        $rss = new RssGen;
        $rss->title = CHtml::encode ($category->title . ' / Категории' . Yii::app ()->config->title_postfix);
        $rss->link = $this->createAbsoluteUrl ('//');
        $rss->desctiption = nl2br (CHtml::encode ($category->about));

        $last_create_post = Yii::app ()->db->createCommand ()->select ('MAX(`create_time`) AS create_time')->from ('{{post}}')->where ('`id_category` = ' . $category->id)->queryRow ();
        $last_update_post = Yii::app ()->db->createCommand ()->select ('MAX(`update_time`) AS update_time')->from ('{{post}}')->where ('`id_category` = ' . $category->id)->queryRow ();

        $rss->pubDate = $last_create_post["create_time"];
        $rss->lastBuildDate = $last_update_post["update_time"];
        $rss->image = Yii::app ()->request->getBaseUrl (TRUE) . '/themes/' . Yii::app ()->theme->name . '/favicon.ico';

        foreach (Post::model ()->loadToRssFromCategory ($category->id)->getData () as $post)
        {

            $item = new RssGenItem;

            $item->title = $post->title;
            $item->link = $this->createAbsoluteUrl ('//post/view', array ('id' => $post->id));
            $item->description = nl2br (bbCode::Format (Smile::Format (CHtml::encode ((Yii::app ()->config->give_in_rss == 'info') ? $post->info_content : $post->cut_content))));
            $item->pubDate = $post->create_time;
            $item->comments = $this->createAbsoluteUrl ('//post/view', array ('id' => $post->id, '#' => 'comment'));
            $item->author = CHtml::encode ($post->user->login);

            $rss->addItem ($item);
        }

        $rss->render ();
    }

    /*
     * RSS для статей с определенным тегом
     */
    public function actionTag ($tag)
    {
        $rss = new RssGen;
        $rss->title = CHtml::encode ($tag . ' / Теги' . Yii::app ()->config->title_postfix);
        $rss->link = $this->createAbsoluteUrl ('//');
        $rss->desctiption = nl2br (CHtml::encode ('Последние статьи с тегом <b>' . $tag . '</b>.'));
        
        $rss->image = Yii::app ()->request->getBaseUrl (TRUE) . '/themes/' . Yii::app ()->theme->name . '/favicon.ico';

        foreach (Post::model ()->loadByTag ($tag, Yii::app ()->config->rss_item_count)->getData () as $post)
        {

            $item = new RssGenItem;

            $item->title = $post->title;
            $item->link = $this->createAbsoluteUrl ('//post/view', array ('id' => $post->id));
            $item->description = nl2br (bbCode::Format (Smile::Format (CHtml::encode ((Yii::app ()->config->give_in_rss == 'info') ? $post->info_content : $post->cut_content))));
            $item->pubDate = $post->create_time;
            $item->comments = $this->createAbsoluteUrl ('//post/view', array ('id' => $post->id, '#' => 'comment'));
            $item->author = CHtml::encode ($post->user->login);

            $rss->addItem ($item);
        }

        $rss->render ();
    }

    /*
     * Комменты к определенной статье
     */
    public function actionComments ($id)
    {
        $post = Post::model ()->findByPk ($id);
        if ($post === NULL) throw new CHttpException (404, 'Статья не найдена');
        
        $rss = new RssGen;
        $rss->title = CHtml::encode ('Комментарии к статье "' . CHtml::encode ($post->title) . '"' . Yii::app ()->config->title_postfix);
        $rss->link = $this->createAbsoluteUrl ('//');
        $rss->desctiption = nl2br (CHtml::encode ('Последние комментарии в формате RSS.
Подписывайтесь и будьте в курсе самых свежих отзывов читателей!'));

        $last_create_comment = Yii::app ()->db->createCommand ()->select ('MAX(`create_time`) AS create_time')->from ('{{comment}}')->where ('`id_post` = ' . $post->id)->queryRow ();

        $rss->pubDate = $rss->lastBuildDate = $last_create_comment["create_time"];
        $rss->image = Yii::app ()->request->getBaseUrl (TRUE) . '/themes/' . Yii::app ()->theme->name . '/favicon.ico';

        foreach (Comment::model ()->loadComments ($post->id)->getData () as $comment)
        {

            $item = new RssGenItem;

            $item->title = 'Комментарий #' . $comment->id;
            $item->link = $this->createAbsoluteUrl ('//post/view', array ('id' => $comment->id_post, '#' => $comment->id));
            $item->description = nl2br (bbCode::Format (Smile::Format (CHtml::encode ($comment->content))));
            $item->pubDate = $comment->create_time;
            $item->author = CHtml::encode ((($comment->login == NULL) ? $comment->user->login : $comment->login));

            $rss->addItem ($item);
        }

        $rss->render ();
    }
}