<?php
/**
 * Controller is the customized base controller class.
 * All controller classes for this application should extend from this base class.
 */
class Controller extends CController
{
	/**
         * Макет страницы
	 * @var string
	 */
	public $layout='//layouts/mobile_base';

        /*
         * Описание страницы (для поисковиков)
         */
        public $description;

        /*
         * Ключевые слова страницы
         */
        public $keyWords;

        /*
         * Выводить ли аналог title вверху страницы
         */
        public $printTopTitle = TRUE;



        /*
         * Инициализация:
         * 
         * 1. Регулярные действия над рекламными ссылками
         * 2. Установка текущей темы
         */
        public function  init()
        {
            parent::init();

            // Регулярные действия над рекламными ссылками
            AdvMemory::model ()->regularActivities ();
            // Установливаем тему
            Yii::app ()->theme = Yii::app ()->config->design;
        }


        
        /*
         * Проверка, главная ли страница
         */
        public function isIndex ()
        {
            return (Yii::app()->controller->id == Yii::app()->defaultController
                && Yii::app()->controller->action->id == Yii::app()->controller->defaultAction);
        }
}