<?php
/*
 * Форма для добавления и редактирования статьи
 */
?>
<div class="menu">

<?php if (Yii::app ()->controller->action->id == 'create' && count ($categoryProvider->getData ()) == 1):// Если в провайдере 1 элемент - категория новостей, выводим сообщение ?>
    Сначала добавьте хотя бы одну категорию!<br />
    <a href="<?php echo $this->createUrl ('category/create') ?>">Добавить категории</a>
<?php else: ?>

<?php $this->widget ('validationErrors', array ('model' => $post)) ?>

<form action="<?php echo $this->createUrl ('', (!$post->isNewRecord) ? array ('id' => $post->id) : array ()) ?>" method="POST">
Заголовок:<br />
<input type="text" name="post[title]"<?php if (!$post->isNewRecord): ?> value="<?php echo CHtml::encode ($post->title) ?>"<?php endif; ?> /><br />

Категория:<br />
<?php if (Yii::app ()->controller->action->id == 'createNews'): ?>
<a class="news" href="<?php echo $this->createUrl ('//category/view', array ('id' => $cat_news->id)) ?>"><b><?php echo CHtml::encode ($cat_news->title) ?></b></a>.<br />
<?php else: ?>

<select name="post[id_category]">
<?php foreach ($categoryProvider->getData () as $category): ?>
<?php if ($category->id != Category::ID_NEWS): ?>
    <option value="<?php echo (int)$category->id ?>"<?php if (!$post->isNewRecord && $post->id_category == $category->id): ?> selected<?php endif; ?> ><?php echo CHtml::encode ($category->title) ?></option>
<?php endif; ?>
<?php endforeach; ?>
</select><br />

<?php endif; ?>

Теги:<br />
<input type="text" name="post[tags]"<?php if (!$post->isNewRecord): ?> value="<?php echo CHtml::encode ($post->tags) ?>"<?php endif; ?> /><br />
    <input type="checkbox" name="post[status]" value="<?php echo Post::STATUS_DRAFT ?>"<?php if (!$post->isNewRecord && $post->status == Post::STATUS_DRAFT): ?> checked<?php endif; ?> /> Сохранить как черновик
<br />
<input type="checkbox" name="post[]" /> Запретить комментирование<br />

<a href="<?php echo $this->createUrl ('//file/add') ?>">Добавить файлы</a><br />

<br />

Аннотация:<br />
<textarea name="post[info_content]" <?php echo Config::getColsRows () ?>><?php if (!$post->isNewRecord) echo CHtml::encode ($post->info_content) ?></textarea><br />

Кат:<br />
<textarea name="post[cut_content]" cols="<?php echo Yii::app ()->config->textarea_cols ?>" rows="<?php echo (Yii::app ()->config->textarea_rows + 5) ?>"><?php if (!$post->isNewRecord) echo CHtml::encode ($post->cut_content) ?></textarea><br />
<input type="submit" value="<?php if (!$post->isNewRecord): ?>Редактировать<?php else: ?>Добавить<?php endif; ?>" /><br />
</form>
    <br />
    <a href="<?php echo $this->createUrl ('textFormat/smiles') ?>">Смайлы</a> | <a href="<?php echo $this->createUrl ('textFormat/bbCodes') ?>">BB-коды</a>

</div>

<?php endif; ?>