<?php
/* 
 * Контроллер установки блога
 */

class DefaultController extends CController
{
    /*
     * Макет страницы
     */
    public $layout = 'install_layout';

    /*
     * Действие по умолчанию
     */
    public $defaultAction = 'Step1';

    /*
     * Выводить ли аналог title вверху страницы
     */
    public $printTopTitle = TRUE;



    /*
     * Переменная с подключением к БД (CDbConnection)
     */
    private $_db;



    /*
     * Заливка таблиц
     */
    private function _dumpTables ($prefix)
    {
        echo preg_replace ('#!!!prefix!!!#u', $prefix, file_get_contents (Yii::getPathOfAlias ('application.data') . '/schema.mysql.sql'));
        exit;

        /*
        $this->_db->active = TRUE;
         */

        /*$db = $this->_db;
        $query = $db->createCommand (preg_replace ('#!!!prefix!!!#u', $prefix, file_get_contents (Yii::getPathOfAlias ('application.data') . '/schema.mysql.sql')));
        $query->execute ();
         /*

        $this->_db->active = FALSE;
        $this->_db->active = TRUE;

        // Заливаем внешние ключи
        $query2 = $db->createCommand (preg_replace ('#!!!prefix!!!#u', $prefix, file_get_contents (Yii::getPathOfAlias ('application.data') . '/foreign_keys.sql')));
        $query2->execute ();
         */

        //$this->_db->exec (preg_replace ('#!!!prefix!!!#u', $prefix, file_get_contents (Yii::getPathOfAlias ('application.data') . '/schema.mysql.sql')));
    }



    /*
     * Шаг 1. Проверка прав доступа
     * А так же автоматическая их настройка (если получится)
     */
    public function actionStep1 ()
    {
        // Массив с путем к файлу и нужными правами
        $filesPerms = array (
            '/protected/runtime' => 707,
            
            '/protected/config' => 707,
            '/protected/config/install.php' => 707,
            
            '/protected/modules/install' => 707,
            
            '/protected/modules/install/controllers' => 707,
            '/protected/modules/install/controllers/DefaultController.php' => 707,
            
            '/protected/modules/install/extensions' => 707,
            
            '/protected/modules/install/extensions/Config_Lite' => 707,
            '/protected/modules/install/extensions/Config_Lite/Config_Lite.php' => 707,
            '/protected/modules/install/extensions/Config_Lite/Lite' => 707,
            '/protected/modules/install/extensions/Config_Lite/Lite/Exception.php' => 707,
            '/protected/modules/install/extensions/Config_Lite/Lite/Exception' => 707,
            '/protected/modules/install/extensions/Config_Lite/Lite/Exception/InvalidArgument.php' => 707,
            '/protected/modules/install/extensions/Config_Lite/Lite/Exception/Runtime.php' => 707,
            '/protected/modules/install/extensions/Config_Lite/Lite/Exception/UnexpectedValue.php' => 707,
            
            '/protected/modules/install/extensions/rmDir' => 707,
            '/protected/modules/install/extensions/rmDir/rmDir.php' => 707,
            
            '/protected/modules/install/models' => 707,
            '/protected/modules/install/models/ConfigForm.php' => 707,
            
            '/protected/modules/install/views' => 707,
            
            '/protected/modules/install/views/default' => 707,
            '/protected/modules/install/views/default/step1.php' => 707,
            '/protected/modules/install/views/default/step2_1.php' => 707,
            '/protected/modules/install/views/default/step2_2.php' => 707,
            '/protected/modules/install/views/default/step3.php' => 707,
            '/protected/modules/install/views/default/step4.php' => 707,
            
            '/protected/modules/install/views/layouts' => 707,
            '/protected/modules/install/views/layouts/install_layout.php' => 707,
            
            
            '/protected/modules/install/InstallModule.php' => 707,
        );

        $this->render ('step1', array (
            'filesPerms' => $filesPerms,
            'runtime' => '/protected/runtime'
        ));
    }

    /*
     * Шаг 2
     * Сохранение настроек подключения к БД в ini файл
     * Заливка таблиц
     */
    public function actionStep2 ()
    {
        /*
        // Если подключение настроено, выводим сообщение о необходимости заливки таблиц
        if (file_exists (APP_ROOT . '/protected/config/' . ConfigForm::$configFile))
        {
            $this->actionDumpTables ();
        }
        // Если нет, предлагаем настроить подключение
        else
        {
         */
        $model = new ConfigForm;

        if (isset ($_POST["config"]))
        {
            $model->attributes = $_POST["config"];
            if ($model->validate ())
            {
                // Сохраняем настройки в ini файл
                $model->saveToIniFile ();

                // Создаем подключение к БД
                //$this->_db = new CDbConnection ('mysql:host=' . $model->host . ';dbname=' . $model->database, $model->username, $model->password);
                //$this->_db = new PDO ('mysql:host=' . $model->host . ';dbname=' . $model->database, $model->username, $model->password);
                

                // Заливаем таблицы
                //$this->_dumpTables ($model->prefix);

                //$this->actionDumpTables ();

                //$this->actionStep3 ();
                $this->redirect (array ('step3'));
                Yii::app ()->end ();
            }
        }
        $this->render ('step2_1', array ('model' => $model));
        //}
    }



    /*
     * Выводим сообщение о необходимости заливки таблиц
     * Вообще-то они должны заливаться сами из скрипта, но при заливке таблиц с внешними ключами, он ведет себя неадекватно
     * Как только проблема будет решена, в скрипте уже есть средства для автоматической заливки
     */
    protected  function actionDumpTables ()
    {
        $is_dump = file_exists (APP_ROOT . '/protected/config/' . ConfigForm::$configFile);
        // Если подключение настроено, выводим сообщение о необходимости заливки таблиц
        $this->render ('step2_2', array (
            'is_dump' => $is_dump
        ));
    }



    /*
     * Шаг 3
     * Регистрация админа
     */
    public function actionStep3 ()
    {
        // Назначаем всем классам Active Record подключение к БД
        //CActiveRecord::$db = $this->_db;

        Yii::import ('application.models.User');
        $model = new User;
        
        if (isset ($_POST["user"]))
        {
            $model->attributes = $_POST["user"];
            if ($model->save ())
            {
                $this->actionStep4 ();
                //$this->redirect (array ('step4'));
                Yii::app ()->end ();
            }
        }
        $this->render ('step3', array ('model' => $model));
    }

    /*
     * Шаг 4
     * Удаление всех связанных с установкой данных
     * Выполняется автоматически после Шага 2
     */
    public function actionStep4 ()
    {
        $this->render ('step4');

        /*
         * Удаляем данные
         * ВНИМАНИЕ!!! Делайте бекапы при тестировании или комментируйте строки
         */
        Yii::import ('install.extensions.rmDir.*');
        
        unlink (Yii::getPathOfAlias ('application.config.install') . '.php');
        
        rmDir::delete (Yii::getPathOfAlias ('application.modules.install'));// !!!!!!!!Внимание, эта строка удаляет установщик!!!
    }
}