<?php

class DefaultController extends Controller {

    /*
     * Действие по умолчанию
     */
    public $defaultAction = 'config';

    /**
     * @return array Фильтры
     */
    public function filters ()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Правила доступа
     * This method is used by the 'accessControl' filter.
     * @return array
     */
    public function accessRules ()
    {
        return array (
            array (
                'allow',// Разрешить доступ авторизованным юзерам (то бишь админу)
                'users' => array ('@')
            ),
            array (
                'allow',// Разрешить обычным юзерам определенные действия
                'users' => array ('?'),
                'actions' => array ('go')
            ),
            array (
                'deny',// Запретить доступ всем остальным юзерам
                'users' => array ('*')
            )
        );
    }

    /**
     * Настройка рекламных ссылок
     */
    public function actionConfig ()
    {
        $this->render ('config',array (
            'topLinkProvider' =>    AdvMemory::loadLinks (Adv::LOCATION_TOP),
            'bottomLinkProvider' => AdvMemory::loadLinks (Adv::LOCATION_BOTTOM)
        ));
    }

    /**
     * Добавление рекламной ссылки
     */
    public function actionAddLink ()
    {
        $model = new AdvMemory;

        if (isset($_POST['adv']))
        {
            $model->attributes = $_POST['adv'];
            if ($model->save())
            {
                $this->render ('//msg', array ('msg' => 'Рекламная ссылка успешно добавлена'));
                Yii::app ()->end ();
            }
        }

        $this->render('add_link', array(
            'model' => $model,
        ));
    }

    /**
     * Изменение ссылки
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate ($id)
    {
        $model = $this->loadModel($id);

        if (isset($_POST['adv']))
        {
            $model->is_explicit = 0;
            $model->attributes = $_POST['adv'];
            if ($model->save())
                $this->redirect (array('config'));
        }

        $this->render('update', array(
            'model' => $model,
        ));
    }

    /**
     * Удаление
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete ($id)
    {
        $link = $this->loadModel ($id);

        if (!isset ($_POST["delete"]))
        {
            $this->render ('delete', array ('link' => $link));
        }
        else
        {
            $link->delete ();
            $this->redirect (array ('config'));
        }
    }
    
    /*
     * Информация о ссылке
     */
    public function actionInfo ($id)
    {
        $this->render ('info', array (
            'link' => $this->loadModel ($id)
        ));
    }

    /*
     * Переход по рекламной ссылке
     */
    public function actionGo ($id)
    {
        $link = $this->loadModel ($id);
        if (Yii::app ()->user->isGuest)
        {
            // Увеличиваем количество переходов (если юзер - не админ)
            $link->real_clicks++;
            $link->save ();
        }

        $this->redirect (CHtml::encode ($link->url));
    }

        /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id)
    {
        $model = AdvMemory::model()->findByPk((int) $id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

}