-- Юзеры
CREATE TABLE `fresh_blog_user`
(
    `id` INT NOT NULL PRIMARY KEY AUTO_INCREMENT,
    `login` VARCHAR(100) NOT NULL,
    `pass` VARCHAR(32) NOT NULL
)
DEFAULT CHARSET = utf8
ENGINE = InnoDB;

-- Категории
CREATE TABLE `fresh_blog_category`
(
    `id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `title` VARCHAR (150) NOT NULL,
    `about` VARCHAR (500)
)
DEFAULT CHARSET = utf8
ENGINE = InnoDB;

-- Начальный дамп системных категорий. Не вздумайте удалять их!
INSERT INTO `fresh_blog_category` VALUES
(1, 'Новости блога', '');

-- Статьи
CREATE TABLE `fresh_blog_post`
(
    `id` INT NOT NULL PRIMARY KEY AUTO_INCREMENT,

    `id_category` INT NOT NULL,
    FOREIGN KEY (`id_category`) REFERENCES `fresh_blog_category` (`id`)
    ON DELETE CASCADE ON UPDATE CASCADE,

    `id_user` INT NOT NULL,
    FOREIGN KEY (`id_user`) REFERENCES `fresh_blog_user` (`id`)
    ON DELETE NO ACTION ON UPDATE CASCADE,

    `create_time` INT NOT NULL,
    `update_time` INT NOT NULL,

    `title` VARCHAR (150) NOT NULL,
    `status` ENUM ('draft', 'published', 'avtopost') NOT NULL, -- Статус статьи. Черновик, опубликована, в очереди на автопостинг
    `type` ENUM ('post', 'news', 'vote') NOT NULL, -- Тип статьи. Обычная статья, новость, опрос (на будущее)

    `positive_votes` INT NOT NULL DEFAULT '0', -- Положительные голоса
    `negative_votes` INT NOT NULL DEFAULT '0', -- Отрицательные голоса

    `unique_views` INT NOT NULL DEFAULT '0',-- Уникальные просмотры
    `all_views` INT NOT NULL DEFAULT '0',-- Все просмотры

    `tags` TEXT,

    `info_content` TEXT NOT NULL,-- Аннотация
    `cut_content` MEDIUMTEXT NOT NULL-- Кат
)
DEFAULT CHARSET = utf8
ENGINE = InnoDB;

-- Комментарии
CREATE TABLE `fresh_blog_comment`
(
    `id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY,

    `id_post` INT NOT NULL,

    FOREIGN KEY (`id_post`) REFERENCES `fresh_blog_post` (`id`)
    ON DELETE CASCADE ON UPDATE CASCADE,

    `id_user` INT NOT NULL,
    -- id_user Тоже надо было бы сделать вторичным ключом, но так как для незарегистрированных юзеров в этот столбец добавляется 0,
    -- а первичный ключ другой таблицы не может быть равен 0, то сойдемся на компромисе, пусть он будет индексом =)
    KEY `id_user` (`id_user`),

    `create_time` INT NOT NULL,
    `ip` VARCHAR (200),
    `user_agent` TEXT,

    `is_see` BOOLEAN, -- Видел ли админ коммент

    `login` VARCHAR (70),
    `content` TEXT NOT NULL
)
DEFAULT CHARSET = utf8
ENGINE = InnoDB;

-- Таблица для облака тегов
CREATE TABLE `fresh_blog_tag`
(
    `id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `name` VARCHAR (100),
    `frequency` INT -- Встречаемость тега
)
DEFAULT CHARSET = utf8
ENGINE = InnoDB;

-- Настройки
CREATE TABLE `fresh_blog_config`
(
    `id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY,

    `design` VARCHAR (500),
    `copyright` VARCHAR (200),

    `print_about_category` BOOLEAN,
    `notify_of_new_comments` BOOLEAN,

    `give_in_rss` ENUM ('info', 'cut'),
    `rss_title` VARCHAR (100),
    `rss_description` VARCHAR (300),
    `rss_item_count` INT,

    `page_count_last_posts` INT,
    `page_count_categories` INT,
    `page_count_comments` INT,
    `tags_cloud_links_count` INT,

    `index_title` VARCHAR (200),
    `index_keywords` VARCHAR (500),
    `index_description` VARCHAR (500),

    `title_postfix` VARCHAR (300),

    `textarea_cols` INT,
    `textarea_rows` INT,

    `auto_determine_site_version` BOOLEAN, -- Определять ли автоматически версию сайта? (Wap/Web)

    `time_last_beckup_adv` INT-- Время последнего бекапа данных с рекламой из таблицы Memory в обычную таблицу

) DEFAULT CHARSET = utf8
ENGINE = InnoDB;

-- Дамп настроек
INSERT INTO `fresh_blog_config` VALUES
(1, 'free4blog', 'Script by Replikon.', 1, 1, 'info', 'Статьи в RSS', 'Здесь транслируются последние статьи блога в формате RSS. Подписывайтесь и будьте всегда в курсе свежих статей!', 15, 3, 5, 7, 25, 'Fresh Blog - свежий wap блог)', 'Fresh Blog блог свежий вап блог Replikon', 'Fresh Blog - свежий wap блог)', ' - Fresh Blog', 30, 7, 0, 0),
(2, 'free4blog', 'Script by Replikon.', 1, 1, 'info', 'Статьи в RSS', 'Здесь транслируются последние статьи блога в формате RSS. Подписывайтесь и будьте всегда в курсе свежих статей!', 15, 3, 5, 7, 25, 'Fresh Blog - свежий wap блог)', 'Fresh Blog блог свежий вап блог Replikon', 'Fresh Blog - свежий wap блог)', ' - Fresh Blog', 30, 7, 0, 0);

-- Рекламные ссылки
CREATE TABLE `fresh_blog_adv`
(
    `id` INT AUTO_INCREMENT NOT NULL PRIMARY KEY,

    `name` VARCHAR (100) NOT NULL,
    `url` VARCHAR (100) NOT NULL,
    `titles` VARCHAR (500) NOT NULL,

    `create_date` INT NOT NULL,
    `term` INT NOT NULL,
    `is_explicit` BOOLEAN NOT NULL,-- Прямая ли ссылка

    `location` ENUM ('top', 'bottom') NOT NULL,

    `views` INT NOT NULL DEFAULT '0',-- Число просмотров
    `wanted_clicks` INT NOT NULL DEFAULT '0',-- Допустимое число переходов для ссылки
    `real_clicks` INT NOT NULL DEFAULT '0'-- Реальное число переходов
)
DEFAULT CHARSET = utf8
ENGINE = InnoDB;

-- Копия таблицы с рекламными ссылками (хранится в оперативной памяти)
CREATE TABLE `fresh_blog_adv_in_memory` AS SELECT * FROM `fresh_blog_adv` WHERE 0;


ALTER TABLE `fresh_blog_adv_in_memory` TYPE = MEMORY;
ALTER TABLE `fresh_blog_adv_in_memory` DEFAULT CHARSET = utf8;
ALTER TABLE `fresh_blog_adv_in_memory` CHANGE `id` `id` INT AUTO_INCREMENT NOT NULL PRIMARY KEY;

-- Статические страницы
CREATE TABLE `fresh_blog_static_page`
(
    `id` INT AUTO_INCREMENT NOT NULL PRIMARY KEY,

    `title` VARCHAR (200) NOT NULL,
    `content` TEXT NOT NULL,

    `key_words` VARCHAR (200),
    `description` VARCHAR (200),
    `is_delete` BOOLEAN DEFAULT '1' -- Возможность удаления страницы
)
DEFAULT CHARSET = utf8
ENGINE = InnoDB;

--
-- Дамп данных таблицы `static_page`
--

INSERT INTO `fresh_blog_static_page` (`id`, `title`, `content`, `key_words`, `description`, `is_delete`) VALUES
(1, 'О блоге', 'Это блог о влиянии противозаконного межвидового спаривания мелких грызунов острова Дрочар на популяцию сибирских белок.', '', '', 0),
(2, 'Рекламодателям', 'Ваши ссылки показываются по круговой системе.\r\nСсылка добавляется вниз, а со временем поднимается все выше.\r\nДоступны 2 площадки для покупки рекламы:\r\n- Верх всех страниц - 700$ в день.\r\n- Низ всех страниц - 900$ в день.\r\nСсылки можно выделять [color=#EFBFCE]разными[/color] [color=#ACDEFB]цветами[/color] - 1400$\r\nи [b]жирным шрифтом[/b] - 80 рублей.\r\nМожно использовать несколько названий.\r\nТакже можно купить определенное количество переходов.\r\n1000 переходов - 1000 рублей.\r\nЕсли хотите, можете купить [b]прямую ссылку[/b] на ваш сайт.\r\nПрямая ссылка - +100 рублей к каждому дню показа.', 'реклама купить', 'Покупка рекламы на сайте Bugaga.org', 1);
