<?php

class TagController extends Controller
{

    /*
     * Действие по умолчанию
     */
    public $defaultAction = 'view';

    /**
     * @return array action filters
     */
    public function filters ()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /*
     * Правила доступа
     * @return array access control rules
     */
    public function accessRules ()
    {
        return array (
            array (
                'allow',
                'users' => array ('@')
            ),
            array (
                'allow',
                'users' => array ('?'),
                'actions' => array ('view', 'viewAll')
            ),
            array (
                'deny',
                'users' => array ('*')
            )
        );
    }



    /*
     * Просмотр статей с определенным тегом
     */
    public function actionView ($tag)
    {
        $this->render ('view', array (
            'postProvider' => Post::model ()->loadByTag ($tag),
            'tag' => $tag
        ));
    }

    /*
     * Просмотр всех тегов
     */
    public function actionViewAll ()
    {
        $this->render ('view_all', array (
            'tagProvider' => Tag::model ()->loadAllTags ()
        ));
    }

    

    /*
     * ПОЛНАЯ синхронизация тегов.
     *
     * В скрипте нигде не используется юзером.
     * Используется при разработке и в случае нарушения целостности системы тегов.
     */
    public function actionSyncAllTags ()
    {
        Tag::model ()->syncAllTags ();
        echo 'Теги полностью синхронизированы';
    }
}