<?php

class StaticPageController extends Controller
{

    /*
     * Действие по умолчанию
     */
    public $defaultAction = 'list';

    /**
     * @return array action filters
     */
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules()
    {
        return array(
            array('allow', // allow all users
                'actions' => array ('view'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionList ()
    {
        $this->render('list', array(
            'pageProvider' => StaticPage::model ()->loadPages (),
        ));
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView ($id)
    {
        $this->render('view', array(
            'page' => StaticPage::model ()->findByPk ($id),
        ));
    }

    /**
     * Добавление страницы
     */
    public function actionCreate ()
    {
        $model = new StaticPage;

        if (isset($_POST['StaticPage']))
        {
            $model->attributes = $_POST['StaticPage'];
            if ($model->save())
                $this->redirect (array('view', 'id' => $model->id));
        }

        $this->render('create', array(
            'page' => $model,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id)
    {
        $model = $this->loadModel($id);

        if (isset($_POST['StaticPage'])) {
            $model->attributes = $_POST['StaticPage'];
            if ($model->save())
                $this->redirect(array('view', 'id' => $model->id));
        }

        $this->render('update', array(
            'page' => $model,
        ));
    }

    /**
     * Deletes a particular model
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete ($id)
    {
        $page = $this->loadModel ($id);

        if ($page->is_delete == 0)
        {
            $this->render ('//msg', array ('msg' => 'Эту страницу удалять нельзя!'));
            Yii::app ()->end ();
        }

        if (!isset ($_POST["delete"]))
        {
            $this->render ('delete', array (
                'page' => $page
            ));
        }
        else
        {
            // Удаляем статью
            $page->delete ();
            $this->redirect (array ('list'));
        }
    }

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel($id)
    {
        $model = StaticPage::model()->findByPk((int) $id);
        if ($model === null)
            throw new CHttpException(404, 'The requested page does not exist.');
        return $model;
    }

}
