<?php
/*
 * Выбор версии сайта (WAP/WEB)
 *
 * Число версий неограниченно.
 * То есть можно сделать, например, еще и версию для сенсоров.
 */

class SiteVersionController extends Controller
{
    /*
     * Действие по умолчанию
     */
    public $defaultAction = 'wap';



    /*
     * Фильтры
     */
    public function filters ()
    {
        return array (
            'accessControl'
        );
    }

    /*
     * Правила доступа
     */
    public function accessRules ()
    {
        return array (
            array (
                'allow',
                'users' => array ('@')// Разрешить доступ авторизованным
            ),
            array (
                'allow',
                'users' => array ('?'),// Разрешить ВСЕ гостям
            ),
            array (
                'deny',
                'users' => array ('*')// Запретить всем остальным
            )
        );
    }



    /*
     * WAP версия сайта для обычных телефонов с маленьким экраном
     */
    public function actionWap ()
    {
        
    }

    /*
     * WEB версия сайта для компьютеров
     */
    public function actionWeb ()
    {

    }

    /*
     * Тестовая TOUCH версия сайта для телефонов с сенсорным экраном
     */
    public function actionTouch ()
    {

    }
}