<?php
/* 
 * Контроллер управления админкой
 */

class AdminController extends Controller
{
    /*
     * Действие по умолчанию
     */
    public $defaultAction = 'Cabinet';



    /*
     * Фильтры
     */
    public function filters ()
    {
        return array (
            'accessControl'
        );
    }

    /*
     * Правила доступа
     */
    public function accessRules ()
    {
        return array (
            array (
                'allow',// Разрешить доступ авторизованным юзерам (то бишь админу)
                'users' => array ('@')
            ),
            array (
                'deny',// Запретить доступ всем остальным юзерам
                'users' => array ('*')
            )
        );
    }



    /*
     * Личный кабинет. Основное место в админке
     */
    public function actionCabinet ()
    {
        $this->render ('cabinet');
    }
}