<?php
    if (Yii::app ()->controller->action->id == 'last') $this->pageTitle = 'Последние комментарии';

    // Массив с идентификаторами статей текущей страницы
    $ids_array = array ();
?>

<?php if (Yii::app ()->controller->action->id == 'view'): ?>
    <div class="title"><a name="comment"></a>Комментарии (<?php echo Comment::model()->getCommentCount ($id_post) ?>)</div>
<?php endif; ?>
<div class="menu">

<?php if (Yii::app ()->controller->action->id == 'last'): ?>
    <img src="<?php echo Yii::app ()->theme->baseUrl ?>/icons/rss.png" alt="rss" /> <a href="<?php echo $this->createUrl ("//rss/lastComments") ?>">Подписка на комментарии</a><br /><br />
<?php endif; ?>

<?php if (Yii::app ()->controller->action->id == 'view'): ?>
    <img src="<?php echo Yii::app ()->theme->baseUrl ?>/icons/pencil_add.png" alt="pencil_add" /> <a href="<?php echo $this->createUrl ('comment/create', array ('id' => $id_post)) ?>">Добавить комментарий</a><br />
    <img src="<?php echo Yii::app ()->theme->baseUrl ?>/icons/rss.png" alt="rss" /> <a href="<?php echo $this->createUrl ('//rss/comments', array ('id' => $id_post)) ?>">Комменты в RSS</a><br /><br />
<?php endif; ?>

<?php if (!count ($commentProvider->getData ())): ?>
    Комментариев нет! Будь первым =)
<?php else: ?>

<?php foreach ($commentProvider->getData () as $comment): ?>

<?php
    // Собираем ID'ы статей НА ТЕКУЩЕЙ СТРАНИЦЕ.
    // Знаю, это костыль и нарушает MVC. Но пока только так.
    $ids_array[] = $comment->id;
?>

<a name="<?php echo $comment->id ?>"></a><div class="commentInfo">
<img src="<?php echo Yii::app ()->theme->baseUrl ?>/icons/say.png" alt="say" />

<?php if ($comment->login != NULL): ?>
    <b><?php echo CHtml::encode ($comment->login) ?></b>
<?php else: ?>
    <span class="admin"><b><?php echo CHtml::encode ($comment->user->login) ?></b></span>
<?php endif; ?>

<span class="small">
    (<a href="<?php echo $this->createUrl ('comment/respond', array ('id' => $comment->id)) ?>">Отв</a>
    | <a href="<?php echo $this->createUrl ('comment/quote', array ('id' => $comment->id)) ?>">Цит</a>)
<?php if (!Yii::app ()->user->isGuest): ?>
    <br />
    [<a href="<?php echo $this->createUrl ('comment/update', array ('id' => $comment->id)) ?>">Изм</a>
    | <a href="<?php echo $this->createUrl ('comment/delete', array ('id' => $comment->id)) ?>">Уд</a>
    | <a href="<?php echo $this->createUrl ('comment/info', array ('id' => $comment->id)) ?>">Инфо</a>]
<?php endif; ?>
</span>
<br />

<?php echo CHtml::encode (Yii::app ()->dateFormatter->format ('d MMMM y, HH:mm', $comment->create_time)) ?>
</div>

<?php if (Yii::app ()->controller->action->id == 'last'): ?>
    К статье <a href="<?php echo $this->createUrl ('post/view', array ('id' => $comment->post->id)) ?>"><?php echo CHtml::encode ($comment->post->title) ?></a>:
<?php endif; ?>

<div class="commentContent">
    <?php echo nl2br (bbCode::Format (Smile::Format (CHtml::encode ($comment->content)))) ?>
</div>
<hr />

<?php endforeach; ?>

<?php
    // Обновляем, если надо, видимость статей админом
    Comment::model ()->updateSeeStatus ($ids_array);
?>

<?php   // Настраиваем параметры, чтобы при навигации переходить сразу к комментам (якорь #comment)
        if (Yii::app ()->controller->id == 'post') $commentProvider->pagination->params = array ('id' => $comment->id_post, '#' => 'comment');
        $this->widget ('Pager', array ('pages' => $commentProvider->pagination)) ?>

<?php endif; ?>

</div>