<?php
$this->pageTitle = 'Информация о рекламной ссылке';
?>
<div class="menu">
<table>

    <tr>
        <td>Имя:</td>
        <td><?php echo CHtml::encode ($link->name) ?>.</td>
    </tr>
    <tr>
        <td>URL:</td>
        <td><a href="<?php echo CHtml::encode ($link->url) ?>"><?php echo CHtml::encode ($link->url) ?></a>.</td>
    </tr>
    <tr>
        <td>Прямая ссылка:</td>
        <td><?php echo $link->is_explicit == 1 ? 'Да' : 'Нет' ?>.</td>
    </tr>
    <tr>
        <td>Названия:</td>
        <td><?php echo nl2br (bbCode::Format (CHtml::encode ($link->titles))) ?></td>
    </tr>
    <tr>
        <td>Установлена:</td>
        <td><?php echo CHtml::encode (Yii::app ()->dateFormatter->format ('d MMMM y, HH:mm', $link->create_date)) ?>.</td>
    </tr>
    <tr>
        <td>Заканчивается:</td>
        <td><?php if ($link->term == 0 && $link->wanted_clicks == 0): ?>
Никогда.
<?php elseif ($link->term == 0 && $link->wanted_clicks != 0): ?>
По завершении всех переходов.
<?php else: ?>
<?php echo CHtml::encode (Yii::app ()->dateFormatter->format ('d MMMM y, HH:mm', ($link->create_date + $link->term * 3600 * 24))) ?>.
<?php endif; ?></td>
    </tr>
    <tr>
        <td>Срок (дней):</td>
        <td><?php echo ($link->term == 0) ? 'Бесконечно' : CHtml::encode ($link->term) ?>.</td>
    </tr>
    <?php if ($link->term != 0): ?><tr>
        <td>Осталось (дней):</td>
        <td><?php echo round ((($link->term * 3600 * 24) - (time () - $link->create_date)) / (3600 * 24), 3) ?>.</td>
    </tr><?php endif; ?>
</table>

<hr />
Просмотров: <b><?php echo (int)$link->views ?></b>.<br />
Переходов: <b><?php echo (int)$link->real_clicks ?>/<?php echo $link->wanted_clicks == 0 ? '&infin;' : (int)$link->wanted_clicks ?></b>.<br />
Процент юзеров, переходящих по ссылке: &asymp;<b><?php echo $link->views == 0 ? 'еще не было не одного перехода' : (round ($link->real_clicks / $link->views, 5) * 100) . '%' ?></b>.
</div>