<?php
/* 
 * Модель для авторизации пользователя
 */

class Login extends CFormModel
{
    public $login;
    public $pass;
    public $rememberMe = TRUE;

    /*
     * Экземпляр класса аутенфикации
     */
    private $_identity;

    /*
     * Время в секундах, в течение которого юзер будет авторизован по cookies
     */
    const TIME_LOGIN = 2592000;// 1 Месяц




    /*
     * Правила валидации
     */
    public function rules ()
    {
        return array (
            array ('login', 'required',
                'message' => 'Вы не ввели логин'),

            array ('pass', 'required',
                'message' => 'Вы не ввели пароль'),

            array ('rememberMe', 'boolean'),
            //array ('rememberMe', 'default', 'value' => TRUE),

            array ('pass', 'authenticate')
        );
    }

    /*
     * Проверка на соответствие логина паролю
     */
    public function authenticate ()
    {
        if (!empty ($this->login) && !empty ($this->pass))
        {
            $this->_identity = new UserIdentity($this->login, $this->pass);
            if (!$this->_identity->authenticate ())
                $this->addError ('pass', 'Неправильный логин или пароль');
            else
                Yii::app ()->user->login ($this->_identity, ($this->rememberMe == TRUE) ? self::TIME_LOGIN : NULL);
        }
    }
}