<?php
/*
 * BB-коды
 */

class bbCode
{
    /*
     * Массив с кодами
     */
    protected static function getPatterns ()
    {
        return array(
            '#\[b\](.+)\[/b\]#uisU',
            '#\[i\](.+)\[/i\]#uisU',
            '#\[u\](.+)\[/u\]#uisU',
            '#\[s\](.+)\[/s\]#uisU',
            '#\[url=(http://|https://|ftp://)(\S+)\](.+)\[/url\]#uisU',
            '#\[color=([a-z0-9\#]+)\](.+)\[/color\]#uisU',
            //'#\[quote=(.+)\](.+)\[/quote\]#uis',
            //'#\[code=([a-z]+)\](.+)\[/code\]#uisU',
            //'',
            //'',
            //'',
    );
    }

    /*
     * Массив с html
     */
    protected static function getHtml ()
    {
        return array(
            '<b>\\1</b>',
            '<i>\\1</i>',
            '<u>\\1</u>',
            '<s>\\1</s>',
            '<a href="\\1\\2">\\3</a>',
            '<span style="color: \\1;">\\2</span>',
            //'<div class="quote_login">\\1 пишет:</div><div class="quote_content">\\2</div>',
            //'',
            //'',
            //'',
        );
    }

    /*
     * Описания
     */
    public static $about = array (
        '[b]жирный текст[/b]',
        '[i]курсив[/i]',
        '[u]подчеркнутый текст[/u]',
        '[s]зачеркнутый текст[/s]',
        '[url=http://ссылка]Название ссылки[/url]',
        '[color=red]Цветной текст[/color]',
        //'[quote=Логин]Текст[/quote]',
        //'',
        //'',
        //'',
        //'',
    );

    /*
     * Подсветка кода.
     */
    protected static function _highlighte ($matches)
    {
        $highlighter = new CTextHighlighter ();
        $highlighter->language = $matches[1];
        return $highlighter->highlight ($matches[2]);
    }



    /*
     * Форматирование исходного текста и замена кодов html
     */
    public static function Format ($str)
    {
        /*
        // Подсветка синтаксиса
        if (!Yii::app ()->user->isGuest) $str = preg_replace_callback ('#\[code=([a-z]+)\](.+)\[/code\]#uisU', "self::_highlighte", htmlspecialchars_decode ($str));
         */
        // bb Коды
        $str = preg_replace (self::getPatterns (), self::getHtml (), $str);

        return $str;
        
    }
}