<?php

/*
 * Управление пользователями
 */
class UserController extends Controller
{
    /*
     * Действие по умолчанию
     */
    public $defaultAction = 'ChangeUserPass';



    /*
     * Фильтры
     */
    public function filters ()
    {
        return array (
            'accessControl'
        );
    }

    /*
     * Правила доступа
     */
    public function accessRules ()
    {
        return array (
            array (
                'allow',// Разрешить доступ авторизованным юзерам (то бишь админу)
                'users' => array ('@')
            ),
            array (
                'deny',// Запретить доступ всем остальным юзерам
                'users' => array ('*')
            )
        );
    }

    

    /*
     * Изменение пароля юзера
     */
    public function actionChangeUserPass ()
    {
        $user = Yii::app ()->user->getModel ();

        if (isset ($_POST["config"]))
        {
            if (!$user->validatePassword ($_POST["config"]["old_pass"]))
            {
                $this->render ('//msg', array ('msg' => 'Неверно введен старый пароль!'));
                Yii::app ()->end ();
            }

            $user->pass = $_POST["config"]["new_pass"];

            if ($user->save ())
            {
                $this->render ('//msg', array ('msg' => 'Пароль успешно изменен.'));
                Yii::app ()->end ();
            }
        }
        $this->render ('change_user_pass', array (
            'user' => $user
        ));
    }

    

    /**
     * Returns the data model based on the primary key given in the GET variable.
     * If the data model is not found, an HTTP exception will be raised.
     * @param integer the ID of the model to be loaded
     */
    public function loadModel ($id)
    {
        $model = User::model()->findByPk((int) $id);
        if ($model === null)
            throw new CHttpException(404, 'Этого пользователя не существует.');
        return $model;
    }

}