<?php

class CommentController extends Controller
{
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

    /*
     * Правила доступа
     */
    public function accessRules ()
    {
        return array (
            array (
                'allow',
                'users' => array ('@')
            ),
            array (
                'allow',
                'users' => array ('?'),
                'actions' => array ('create', 'respond', 'quote', 'last')
            ),
            array (
                'deny',
                'users' => array ('*')
            )
        );
    }



	/**
	 * Добавление нового комментария
	 */
	public function actionCreate ($id)
	{
		// Если статьи не существует
                if (!$post = Post::model ()->findByPk ($id))
                        throw new CHttpException(404,'Этой статьи не существует');;
                // Если статья - черновик, посылаем юзера (если он не админ)
                if ($post->status == Post::STATUS_DRAFT && Yii::app ()->user->isGuest)
                        $this->redirect (array ('//login'));;

                $model=new Comment;

		if(isset($_POST['comment']))
		{
			$model->id_post = $id;
                        $model->attributes=$_POST['comment'];
			if($model->save())
			{
                            if ($model->login != NULL)
                            {
                                // Запоминаем логин юзера в куках
                                $cookie = new CHttpCookie (Config::COOKIE_PREFIX . Comment::COOKIE_USER, $model->login);
                                $cookie->expire = time () + Comment::COOKIE_LIFE;
                                Yii::app ()->request->cookies[Comment::COOKIE_USER] = $cookie;
                            }
                            $this->redirect(array('post/view','id'=>$id, '#' => 'comment'));
                        }
		}

		$this->render('create',array(
			'comment'=>$model,
                        'id' => $id
		));
	}

        /*
         * Ответ на комментарий
         */
        public function actionRespond ($id)
        {
            $model=new Comment;
            $respondedComment = $this->loadModel ($id);

            // Если статья - черновик, посылаем юзера (если он не админ)
            $post = Post::model ()->findByPk ($respondedComment->id_post);
            if ($post->status == Post::STATUS_DRAFT && Yii::app ()->user->isGuest)
                    $this->redirect (array ('//login'));;

            if(isset($_POST['comment']))
            {
                $model->id_post = $respondedComment->id_post;
                $model->attributes=$_POST['comment'];
                if($model->save())
			{
                            if ($model->login != NULL)
                            {
                                // Запоминаем логин юзера в куках
                                $cookie = new CHttpCookie (Config::COOKIE_PREFIX . Comment::COOKIE_USER, $model->login);
                                $cookie->expire = time () + Comment::COOKIE_LIFE;
                                Yii::app ()->request->cookies[Comment::COOKIE_USER] = $cookie;
                            }
                            $this->redirect(array('post/view','id'=>$respondedComment->id_post, '#' => 'comment'));
                        }
            }

            $this->render ((Yii::app ()->controller->action->id == 'respond') ? 'respond' : 'quote', array (
                'respondedComment' => $respondedComment,
                'comment' => $model
            ));
        }

        /*
         * Цитирование
         */
        public function actionQuote ($id)
        {
            $this->actionRespond ($id);
        }

	/**
	 * Обновление комментария
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate ($id)
	{
            $model=$this->loadModel($id);
            if(isset($_POST['comment']))
            {
                $model->attributes=$_POST['comment'];
                if($model->save())
                        $this->redirect(array('post/view','id'=>$model->id_post, '#' => 'comment'));
            }

            $this->render('update',array(
                'model'=>$model,
            ));
	}

	/**
	 * Удаление комментария
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete ($id)
	{
            $model = $this->loadModel($id);
            if (!isset ($_POST["delete"]))
            {
                $this->render ('delete', array ('comment' => $model));
            }
            else
            {
                $model->delete ();
                $this->redirect(array('post/view','id'=>$model->id_post, '#' => 'comment'));
            }
	}

        /*
         * Информация о комментарии
         * @param integer $id ID коммента в базе
         */
        public function actionInfo ($id)
        {
            $this->render ('info', array (
                'comment' => $this->loadModel ($id)
            ));
        }

        /*
         * Последние комментарии
         */
        public function actionLast ()
        {
            $this->render ('_viewComments', array (
                'commentProvider' => Comment::model ()->loadLastComments ()
            ));
        }

        /*
         * Непрочитанные комментарии
         */
        public function actionNew ()
        {
            $this->render ('new', array (
                'commentProvider' => Comment::model ()->loadNewComments ()
            ));
        }


	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Comment::model()->findByPk((int)$id);
		if($model===null)
			throw new CHttpException(404,'Этого комментария не существует');
		return $model;
	}
}
