/*
 * Decompiled with CFR 0.152.
 */
package org.qcontinuum.compass;

import java.util.Date;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import org.qcontinuum.astro.HorizontalPosition;
import org.qcontinuum.astro.RiseSetTime;
import org.qcontinuum.compass.Compass;
import org.qcontinuum.compass.InfoDisplay;
import org.qcontinuum.compass.Location;
import org.qcontinuum.compass.Progress;
import org.qcontinuum.compass.SunMoonPosition;

public class InfoSun
extends Progress {
    private Displayable a;

    public InfoSun(Displayable displayable) {
        super("Sun", displayable);
        this.a = displayable;
        this.start();
    }

    public void run() {
        Date date = Compass.getDate();
        SunMoonPosition sunMoonPosition = new SunMoonPosition(date);
        HorizontalPosition horizontalPosition = sunMoonPosition.getSunPosition();
        Location location = Compass.getPreferences().getLocation();
        RiseSetTime riseSetTime = new RiseSetTime(0, location.getGmt(date), location.getDstOffset(date), location.getEarthPosition());
        InfoDisplay infoDisplay = new InfoDisplay("Sun", this.a);
        infoDisplay.append((Item)new StringItem("Azimuth:", Compass.getFloat(horizontalPosition.getAzimuthFloat(), 1) + "\u00b0\n"));
        infoDisplay.append((Item)new StringItem("Altitude:", Compass.getFloat(horizontalPosition.getElevationFloat(), 1) + "\u00b0\n"));
        infoDisplay.append((Item)new StringItem(null, " \n"));
        infoDisplay.append((Item)new StringItem("Rise:", Compass.getTime(riseSetTime.getRiseTime()) + "\n"));
        infoDisplay.append((Item)new StringItem("Transit:", Compass.getTime(riseSetTime.getTransitTime()) + "\n"));
        infoDisplay.append((Item)new StringItem("Set:", Compass.getTime(riseSetTime.getSetTime())));
        if (this.isShown()) {
            Compass.display((Displayable)infoDisplay);
        }
    }
}

